/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JMods;
import com.helger.jcodemodel.JVar;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JCatchBlock
implements IJGenerable {
    private final AbstractJClass m_aException;
    private JVar m_aVar;
    private final JBlock m_aBody = new JBlock();

    protected JCatchBlock(@Nonnull AbstractJClass abstractJClass) {
        this.m_aException = abstractJClass;
    }

    @Nonnull
    public AbstractJClass exception() {
        return this.m_aException;
    }

    @Nonnull
    public JVar param(String string) {
        if (this.m_aVar != null) {
            throw new IllegalStateException("A variable is already present!");
        }
        this.m_aVar = new JVar(JMods.forVar(8), this.m_aException, string, null);
        return this.m_aVar;
    }

    @Nullable
    public JVar param() {
        return this.m_aVar;
    }

    @Nonnull
    public JBlock body() {
        return this.m_aBody;
    }

    @Override
    public void generate(@Nonnull IJFormatter iJFormatter) {
        if (this.m_aVar == null) {
            this.m_aVar = new JVar(JMods.forVar(8), this.m_aException, "ex", null);
        }
        iJFormatter.print("catch (").var(this.m_aVar).print(')').generable(this.m_aBody);
    }
}

