/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJFormatter;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JCommentPart
extends ArrayList<Object> {
    @Nonnull
    public JCommentPart append(@Nullable Object object) {
        this.add(object);
        return this;
    }

    @Override
    public boolean add(@Nullable Object object) {
        return this._flattenAppend(object);
    }

    @Nullable
    public static String getHTMLEscaped(@Nullable String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        for (char c : string.toCharArray()) {
            if (c == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            if (c == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuilder.append("&gt;");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("&quot;");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public boolean addMasked(@Nullable String string) {
        String string2 = JCommentPart.getHTMLEscaped(string);
        if (string2 == null) {
            return false;
        }
        return super.add(string2);
    }

    private boolean _flattenAppend(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        boolean bl = false;
        if (object instanceof Object[]) {
            for (Object object2 : (Object[])object) {
                if (!this._flattenAppend(object2)) continue;
                bl = true;
            }
        } else if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                if (!this._flattenAppend(e)) continue;
                bl = true;
            }
        } else if (object instanceof String || object instanceof AbstractJType) {
            bl = super.add(object);
        } else {
            throw new IllegalArgumentException("Value is of an unsupported type: " + object.getClass().toString());
        }
        return bl;
    }

    protected void format(@Nonnull IJFormatter iJFormatter, String string) {
        if (!iJFormatter.isPrinting()) {
            for (Object e : this) {
                if (!(e instanceof AbstractJClass)) continue;
                iJFormatter.generable((AbstractJClass)e);
            }
            return;
        }
        if (!this.isEmpty()) {
            iJFormatter.print(string);
        }
        for (Object e : this) {
            if (e instanceof String) {
                int n;
                String string2 = (String)e;
                while ((n = string2.indexOf(10)) != -1) {
                    String string3 = string2.substring(0, n);
                    if (string3.length() > 0) {
                        iJFormatter.print(JCommentPart._escape(string3));
                    }
                    string2 = string2.substring(n + 1);
                    iJFormatter.newline().print(string);
                }
                if (string2.length() == 0) continue;
                iJFormatter.print(JCommentPart._escape(string2));
                continue;
            }
            if (e instanceof AbstractJClass) {
                ((AbstractJClass)e).printLink(iJFormatter);
                continue;
            }
            if (e instanceof AbstractJType) {
                iJFormatter.generable((AbstractJType)e);
                continue;
            }
            throw new IllegalStateException("Invalid type present: " + e);
        }
        if (!this.isEmpty()) {
            iJFormatter.newline();
        }
    }

    @Nonnull
    private static String _escape(@Nonnull String string) {
        int n;
        String string2 = string;
        while ((n = string2.indexOf("*/")) >= 0) {
            string2 = string2.substring(0, n + 1) + "<!---->" + string2.substring(n + 1);
        }
        return string2;
    }
}

