/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JOp;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;

public class JConditional
implements IJStatement {
    private final IJExpression m_aTestExpr;
    private final JBlock m_aThenBlock = new JBlock();
    private JBlock m_aElseBlock;

    public JConditional(@Nonnull IJExpression iJExpression) {
        JCValueEnforcer.notNull(iJExpression, "Test expression");
        this.m_aTestExpr = iJExpression;
    }

    @Nonnull
    public IJExpression test() {
        return this.m_aTestExpr;
    }

    @Nonnull
    public JBlock _then() {
        return this.m_aThenBlock;
    }

    @Nonnull
    public JBlock _else() {
        if (this.m_aElseBlock == null) {
            this.m_aElseBlock = new JBlock();
        }
        return this.m_aElseBlock;
    }

    @Nonnull
    public JConditional _elseif(@Nonnull IJExpression iJExpression) {
        return this._else()._if(iJExpression);
    }

    @Override
    public void state(@Nonnull IJFormatter iJFormatter) {
        if (this.m_aTestExpr == JExpr.TRUE) {
            this.m_aThenBlock.generateBody(iJFormatter);
            return;
        }
        if (this.m_aTestExpr == JExpr.FALSE) {
            this.m_aElseBlock.generateBody(iJFormatter);
            return;
        }
        if (JOp.hasTopOp(this.m_aTestExpr)) {
            iJFormatter.print("if ").generable(this.m_aTestExpr);
        } else {
            iJFormatter.print("if (").generable(this.m_aTestExpr).print(')');
        }
        iJFormatter.generable(this.m_aThenBlock);
        if (this.m_aElseBlock != null) {
            iJFormatter.print("else").generable(this.m_aElseBlock);
        }
        iJFormatter.newline();
    }
}

