/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.JArray;
import com.helger.jcodemodel.JArrayCompRef;
import com.helger.jcodemodel.JAssignment;
import com.helger.jcodemodel.JAtom;
import com.helger.jcodemodel.JAtomDouble;
import com.helger.jcodemodel.JAtomFloat;
import com.helger.jcodemodel.JAtomInt;
import com.helger.jcodemodel.JAtomLong;
import com.helger.jcodemodel.JCast;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JEnumConstantRef;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JNarrowedClass;
import com.helger.jcodemodel.JOp;
import com.helger.jcodemodel.JOpTernary;
import com.helger.jcodemodel.JOpUnaryTight;
import com.helger.jcodemodel.JStringLiteral;
import com.helger.jcodemodel.JVar;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JExpr {
    @Nonnull
    public static final JAtom TRUE = new JAtom("true");
    @Nonnull
    public static final JAtom FALSE = new JAtom("false");
    private static final String CHAR_ESCAPE = "\b\t\n\f\r\"'\\";
    private static final String CHAR_MACRO = "btnfr\"'\\";
    private static final JAtom THIS = new JAtom("this");
    private static final JAtom SUPER = new JAtom("super");
    private static final JAtom NULL = new JAtom("null");

    private JExpr() {
    }

    @Nonnull
    public static JAssignment assign(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        return new JAssignment(iJAssignmentTarget, iJExpression);
    }

    @Nonnull
    public static JAssignment assignPlus(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        return new JAssignment(iJAssignmentTarget, iJExpression, "+");
    }

    @Nonnull
    public static JAssignment assignMinus(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        return new JAssignment(iJAssignmentTarget, iJExpression, "-");
    }

    @Nonnull
    public static JAssignment assignTimes(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        return new JAssignment(iJAssignmentTarget, iJExpression, "*");
    }

    @Nonnull
    public static JAssignment assignDivide(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        return new JAssignment(iJAssignmentTarget, iJExpression, "/");
    }

    @Nonnull
    public static JAssignment assignShl(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        return new JAssignment(iJAssignmentTarget, iJExpression, "<<");
    }

    @Nonnull
    public static JAssignment assignShr(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        return new JAssignment(iJAssignmentTarget, iJExpression, ">>");
    }

    @Nonnull
    public static JAssignment assignShrz(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        return new JAssignment(iJAssignmentTarget, iJExpression, ">>>");
    }

    @Nonnull
    public static JAssignment assignBand(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        return new JAssignment(iJAssignmentTarget, iJExpression, "&");
    }

    @Nonnull
    public static JAssignment assignXor(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        return new JAssignment(iJAssignmentTarget, iJExpression, "^");
    }

    @Nonnull
    public static JAssignment assignBor(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        return new JAssignment(iJAssignmentTarget, iJExpression, "|");
    }

    @Nonnull
    public static JOpUnaryTight incr(@Nonnull IJExpression iJExpression) {
        return JOp.postincr(iJExpression);
    }

    @Nonnull
    public static JOpUnaryTight preincr(@Nonnull IJExpression iJExpression) {
        return JOp.preincr(iJExpression);
    }

    @Nonnull
    public static JOpUnaryTight decr(@Nonnull IJExpression iJExpression) {
        return JOp.postdecr(iJExpression);
    }

    @Nonnull
    public static JOpUnaryTight predecr(@Nonnull IJExpression iJExpression) {
        return JOp.predecr(iJExpression);
    }

    @Nonnull
    public static JInvocation _new(@Nonnull AbstractJType abstractJType) {
        return new JInvocation(abstractJType);
    }

    @Nonnull
    public static JInvocation invoke(@Nonnull String string) {
        return JExpr.invoke((IJExpression)null, string);
    }

    @Nonnull
    public static JInvocation invokeThis(@Nonnull String string) {
        return JExpr.invoke((IJExpression)JExpr._this(), string);
    }

    @Nonnull
    public static JInvocation invoke(@Nonnull JMethod jMethod) {
        return JExpr.invoke((IJExpression)null, jMethod);
    }

    @Nonnull
    public static JInvocation invokeThis(@Nonnull JMethod jMethod) {
        return JExpr.invoke((IJExpression)JExpr._this(), jMethod);
    }

    @Nonnull
    public static JInvocation invoke(@Nullable IJExpression iJExpression, @Nonnull JMethod jMethod) {
        return new JInvocation(jMethod.owner(), (IJGenerable)iJExpression, jMethod);
    }

    @Nonnull
    public static JInvocation invoke(@Nullable IJExpression iJExpression, @Nonnull String string) {
        return new JInvocation((JCodeModel)null, (IJGenerable)iJExpression, string);
    }

    @Nonnull
    public static JInvocation invoke(@Nullable JCodeModel jCodeModel, @Nullable IJExpression iJExpression, @Nonnull String string) {
        return new JInvocation(jCodeModel, (IJGenerable)iJExpression, string);
    }

    @Nonnull
    public static JInvocation invokeSuper() {
        return JInvocation._super();
    }

    @Nonnull
    public static JFieldRef ref(@Nonnull JVar jVar) {
        return JExpr.ref(null, jVar);
    }

    @Nonnull
    public static JFieldRef ref(@Nonnull String string) {
        return JExpr.ref(null, string);
    }

    @Nonnull
    public static JFieldRef ref(@Nullable IJExpression iJExpression, @Nonnull JVar jVar) {
        return new JFieldRef(iJExpression, jVar);
    }

    @Nonnull
    public static JFieldRef ref(@Nullable IJExpression iJExpression, @Nonnull String string) {
        return new JFieldRef(iJExpression, string);
    }

    @Nonnull
    public static JEnumConstantRef enumConstantRef(@Nonnull AbstractJClass abstractJClass, @Nonnull String string) {
        return new JEnumConstantRef(abstractJClass, string);
    }

    @Nonnull
    public static JFieldRef refthis(@Nonnull JVar jVar) {
        return new JFieldRef(null, jVar, true);
    }

    @Nonnull
    public static JFieldRef refthis(@Nonnull String string) {
        return new JFieldRef(null, string, true);
    }

    @Nonnull
    public static JFieldRef refthis(@Nullable IJExpression iJExpression, @Nonnull JVar jVar) {
        return new JFieldRef((IJGenerable)iJExpression, jVar, true);
    }

    @Nonnull
    public static JFieldRef refthis(@Nullable IJExpression iJExpression, @Nonnull String string) {
        return new JFieldRef((IJGenerable)iJExpression, string, true);
    }

    @Nonnull
    @Deprecated
    public static IJExpression dotclass(@Nonnull AbstractJClass abstractJClass) {
        return JExpr.dotClass(abstractJClass);
    }

    @Nonnull
    public static IJExpression dotClass(@Nonnull AbstractJType abstractJType) {
        return iJFormatter -> {
            AbstractJType abstractJType2 = abstractJType instanceof JNarrowedClass ? ((JNarrowedClass)abstractJType).basis() : abstractJType;
            iJFormatter.generable(abstractJType2).print(".class");
        };
    }

    @Nonnull
    public static JArrayCompRef component(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JArrayCompRef(iJExpression, iJExpression2);
    }

    @Nonnull
    public static JCast cast(@Nonnull AbstractJType abstractJType, @Nonnull IJExpression iJExpression) {
        return new JCast(abstractJType, iJExpression);
    }

    @Nonnull
    public static JArray newArray(@Nonnull AbstractJType abstractJType) {
        return JExpr.newArray(abstractJType, null);
    }

    @Nonnull
    public static JArray newArray(@Nonnull AbstractJType abstractJType, @Nullable IJExpression iJExpression) {
        return new JArray(abstractJType.erasure(), iJExpression);
    }

    @Nonnull
    public static JArray newArray(@Nonnull AbstractJType abstractJType, @Nonnegative int n) {
        return JExpr.newArray(abstractJType, JExpr.lit(n));
    }

    @Nonnull
    public static JAtom _this() {
        return THIS;
    }

    @Nonnull
    public static JAtom _super() {
        return SUPER;
    }

    @Nonnull
    public static JAtom _null() {
        return NULL;
    }

    @Nonnull
    public static JAtom lit(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    @Nonnull
    public static JAtomInt lit(int n) {
        return new JAtomInt(n);
    }

    @Nonnull
    public static JAtomLong lit(long l) {
        return new JAtomLong(l);
    }

    @Nonnull
    public static JAtomFloat lit(float f) {
        return new JAtomFloat(f);
    }

    @Nonnull
    public static JAtomDouble lit(double d) {
        return new JAtomDouble(d);
    }

    @Nonnull
    public static String quotify(char c, @Nonnull String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 2);
        stringBuilder.append(c);
        for (char c2 : string.toCharArray()) {
            int n2 = CHAR_ESCAPE.indexOf(c2);
            if (n2 >= 0) {
                if (c == '\"' && c2 == '\'' || c == '\'' && c2 == '\"') {
                    stringBuilder.append(c2);
                    continue;
                }
                stringBuilder.append('\\');
                stringBuilder.append(CHAR_MACRO.charAt(n2));
                continue;
            }
            if (c2 < ' ' || c2 > '~') {
                stringBuilder.append("\\u");
                String string2 = Integer.toHexString(c2 & 0xFFFF);
                for (int i = string2.length(); i < 4; ++i) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append(c2);
        }
        stringBuilder.append(c);
        return stringBuilder.toString();
    }

    @Nonnull
    public static JAtom lit(char c) {
        return new JAtom(JExpr.quotify('\'', Character.toString(c)));
    }

    @Nonnull
    public static JStringLiteral lit(@Nonnull String string) {
        return new JStringLiteral(string);
    }

    @Nonnull
    public static IJExpression direct(@Nonnull String string) {
        return iJFormatter -> iJFormatter.print('(').print(string).print(')');
    }

    @Nonnull
    public static JOpTernary cond(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2, @Nonnull IJExpression iJExpression3) {
        return JOp.cond(iJExpression, iJExpression2, iJExpression3);
    }
}

