/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.IJOwnedMaybe;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JVar;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JFieldRef
implements IJAssignmentTarget,
IJOwnedMaybe {
    private final JCodeModel m_aOwner;
    private final IJGenerable m_aObject;
    private final String m_sName;
    private final JVar m_aVar;
    private boolean m_bExplicitThis;

    protected JFieldRef(@Nullable IJExpression iJExpression, @Nonnull String string) {
        this(null, iJExpression, string, null, false);
    }

    protected JFieldRef(@Nullable IJExpression iJExpression, @Nonnull JVar jVar) {
        this(null, iJExpression, null, jVar, false);
    }

    protected JFieldRef(@Nonnull AbstractJType abstractJType, @Nonnull String string) {
        this(abstractJType.owner(), abstractJType, string, null, false);
    }

    protected JFieldRef(@Nonnull AbstractJType abstractJType, @Nonnull JVar jVar) {
        this(abstractJType.owner(), abstractJType, null, jVar, false);
    }

    protected JFieldRef(@Nullable IJGenerable iJGenerable, @Nonnull String string, boolean bl) {
        this(null, iJGenerable, string, null, bl);
    }

    protected JFieldRef(@Nullable IJGenerable iJGenerable, @Nonnull JVar jVar, boolean bl) {
        this(null, iJGenerable, null, jVar, bl);
    }

    private JFieldRef(@Nullable JCodeModel jCodeModel, @Nullable IJGenerable iJGenerable, @Nullable String string, @Nullable JVar jVar, boolean bl) {
        JCValueEnforcer.isTrue(string == null || string.indexOf(46) < 0, () -> "Field name contains '.': " + string);
        JCValueEnforcer.isFalse(string == null && jVar == null, "name or var must be present");
        this.m_aOwner = jCodeModel;
        this.m_aObject = iJGenerable;
        this.m_sName = string;
        this.m_aVar = jVar;
        this.m_bExplicitThis = bl;
    }

    @Override
    @Nullable
    public JCodeModel owner() {
        return this.m_aOwner;
    }

    @Nullable
    public IJGenerable object() {
        return this.m_aObject;
    }

    @Nonnull
    public String name() {
        String string = this.m_sName;
        if (string == null) {
            string = this.m_aVar.name();
        }
        return string;
    }

    @Nullable
    public JVar var() {
        return this.m_aVar;
    }

    public boolean explicitThis() {
        return this.m_bExplicitThis;
    }

    @Nonnull
    public JFieldRef explicitThis(boolean bl) {
        this.m_bExplicitThis = bl;
        return this;
    }

    @Override
    public void generate(@Nonnull IJFormatter iJFormatter) {
        String string = this.name();
        if (this.m_aObject != null) {
            if (this.m_aObject instanceof AbstractJType) {
                iJFormatter.type((AbstractJType)this.m_aObject);
            } else {
                iJFormatter.generable(this.m_aObject);
            }
            iJFormatter.print('.').print(string);
        } else if (this.m_bExplicitThis) {
            iJFormatter.print("this.").print(string);
        } else {
            iJFormatter.id(string);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JFieldRef jFieldRef = (JFieldRef)object;
        return JCEqualsHelper.isEqual(this.m_aObject, jFieldRef.m_aObject) && JCEqualsHelper.isEqual(this.name(), jFieldRef.name()) && JCEqualsHelper.isEqual(this.m_bExplicitThis, jFieldRef.m_bExplicitThis);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this.m_aObject, this.name(), this.m_bExplicitThis);
    }
}

