/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import java.util.HashSet;
import javax.annotation.Nonnull;

public final class JJavaName {
    private static final HashSet<String> RESERVED_KEYWORDS;

    private JJavaName() {
    }

    public static boolean isJavaIdentifier(@Nonnull String string) {
        if (string.length() == 0) {
            return false;
        }
        if (RESERVED_KEYWORDS.contains(string)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isFullyQualifiedClassName(String string) {
        return JJavaName.isJavaPackageName(string);
    }

    public static boolean isJavaPackageName(String string) {
        String string2 = string;
        while (string2.length() != 0) {
            int n = string2.indexOf(46);
            if (n == -1) {
                n = string2.length();
            }
            if (!JJavaName.isJavaIdentifier(string2.substring(0, n))) {
                return false;
            }
            if ((string2 = string2.substring(n)).length() == 0) continue;
            string2 = string2.substring(1);
        }
        return true;
    }

    static {
        String[] stringArray;
        RESERVED_KEYWORDS = new HashSet();
        for (String string : stringArray = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "var", "void", "volatile", "while", "true", "false", "null", "assert", "enum"}) {
            RESERVED_KEYWORDS.add(string);
        }
    }
}

