/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.JLambdaBlock;
import com.helger.jcodemodel.JLambdaParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JLambda
implements IJExpression {
    private final List<JLambdaParam> m_aParams = new ArrayList<JLambdaParam>();
    private final JLambdaBlock m_aBodyStatement = new JLambdaBlock();

    @Nonnull
    public JLambdaParam addParam(@Nonnull String string) {
        JLambdaParam jLambdaParam = new JLambdaParam(null, string);
        this.m_aParams.add(jLambdaParam);
        return jLambdaParam;
    }

    @Nonnull
    public JLambdaParam addParam(@Nullable AbstractJType abstractJType, @Nonnull String string) {
        JLambdaParam jLambdaParam = new JLambdaParam(abstractJType, string);
        this.m_aParams.add(jLambdaParam);
        return jLambdaParam;
    }

    @Nonnull
    public List<JLambdaParam> params() {
        return Collections.unmodifiableList(this.m_aParams);
    }

    @Nonnegative
    public int paramCount() {
        return this.m_aParams.size();
    }

    @Nonnull
    public JLambdaBlock body() {
        return this.m_aBodyStatement;
    }

    @Override
    public void generate(@Nonnull IJFormatter iJFormatter) {
        int n = this.m_aParams.size();
        if (n > 0) {
            JLambdaParam jLambdaParam = this.m_aParams.get(0);
            for (int i = 1; i < n; ++i) {
                if (this.m_aParams.get(i).hasType() == jLambdaParam.hasType()) continue;
                throw new IllegalStateException("Lambda expression parameters must all have types or none may have a type!");
            }
        }
        if (this.m_aBodyStatement.isEmpty()) {
            throw new IllegalStateException("Lambda expression is empty!");
        }
        if (n == 0) {
            iJFormatter.print("()");
        } else if (n == 1 && !this.m_aParams.get(0).hasType()) {
            this.m_aParams.get(0).declare(iJFormatter);
        } else {
            iJFormatter.print('(');
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    iJFormatter.print(',');
                }
                this.m_aParams.get(i).declare(iJFormatter);
            }
            iJFormatter.print(')');
        }
        iJFormatter.print(" -> ");
        boolean bl = this.m_aBodyStatement.size() != 1 || !(this.m_aBodyStatement.getContents().get(0) instanceof IJExpression);
        this.m_aBodyStatement.bracesRequired(bl);
        iJFormatter.statement(this.m_aBodyStatement);
    }

    @Nonnull
    public static JLambda simple(@Nonnull IJExpression iJExpression) {
        JLambda jLambda = new JLambda();
        jLambda.body().lambdaExpr(iJExpression);
        return jLambda;
    }
}

