/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.EClassType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJClassContainer;
import com.helger.jcodemodel.IJDeclaration;
import com.helger.jcodemodel.IJDocCommentable;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JDocComment;
import com.helger.jcodemodel.fmt.AbstractJResourceFile;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JPackage
implements IJDeclaration,
IJGenerable,
IJClassContainer<JDefinedClass>,
IJAnnotatable,
IJDocCommentable {
    private final String m_sName;
    private final JCodeModel m_aOwner;
    private final Map<String, JDefinedClass> m_aClasses = new TreeMap<String, JDefinedClass>();
    private final Set<AbstractJResourceFile> m_aResources = new HashSet<AbstractJResourceFile>();
    private final Map<String, JDefinedClass> m_aUpperCaseClassMap;
    private List<JAnnotationUse> m_aAnnotations;
    private JDocComment m_aJavaDoc;

    protected JPackage(@Nonnull String string, @Nonnull JCodeModel jCodeModel) {
        JCValueEnforcer.notNull(string, "Name");
        JCValueEnforcer.isFalse(string.equals("."), "Package name . is not allowed");
        JCValueEnforcer.notNull(jCodeModel, "CodeModel");
        this.m_aOwner = jCodeModel;
        this.m_sName = string;
        this.m_aUpperCaseClassMap = JCodeModel.isFileSystemCaseSensitive() ? null : new HashMap<String, JDefinedClass>();
    }

    @Override
    @Nullable
    public IJClassContainer<?> parentContainer() {
        return this.parent();
    }

    @Nullable
    public JPackage parent() {
        if (this.isUnnamed()) {
            return null;
        }
        int n = this.m_sName.lastIndexOf(46);
        if (n < 0) {
            return this.m_aOwner.rootPackage();
        }
        return this.m_aOwner._package(this.m_sName.substring(0, n));
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isPackage() {
        return true;
    }

    @Override
    @Nonnull
    public JPackage getPackage() {
        return this;
    }

    @Override
    @Nonnull
    public JDefinedClass _class(int n, @Nonnull String string, @Nonnull EClassType eClassType) throws JClassAlreadyExistsException {
        if (this.m_aClasses.containsKey(string)) {
            throw new JClassAlreadyExistsException(this.m_aClasses.get(string));
        }
        JDefinedClass jDefinedClass = new JDefinedClass(this, n, string, eClassType);
        if (this.m_aUpperCaseClassMap != null) {
            String string2 = string.toUpperCase();
            JDefinedClass jDefinedClass2 = this.m_aUpperCaseClassMap.get(string2);
            if (jDefinedClass2 != null) {
                throw new JClassAlreadyExistsException(jDefinedClass2);
            }
            this.m_aUpperCaseClassMap.put(string2, jDefinedClass);
        }
        this.m_aClasses.put(string, jDefinedClass);
        return jDefinedClass;
    }

    @Nullable
    public JDefinedClass _getClass(@Nullable String string) {
        return this.m_aClasses.get(string);
    }

    @Nonnull
    public AbstractJResourceFile addResourceFile(@Nonnull AbstractJResourceFile abstractJResourceFile) {
        JCValueEnforcer.notNull(abstractJResourceFile, "ResourceFile");
        this.m_aResources.add(abstractJResourceFile);
        return abstractJResourceFile;
    }

    public boolean hasResourceFile(@Nullable String string) {
        for (AbstractJResourceFile abstractJResourceFile : this.m_aResources) {
            if (!abstractJResourceFile.name().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    @Nonnull
    public Iterator<AbstractJResourceFile> propertyFiles() {
        return this.resourceFiles();
    }

    @Nonnull
    public Iterator<AbstractJResourceFile> resourceFiles() {
        return this.m_aResources.iterator();
    }

    @Nonnull
    public List<AbstractJResourceFile> getAllResourceFiles() {
        return new ArrayList<AbstractJResourceFile>(this.m_aResources);
    }

    @Override
    @Nonnull
    public JDocComment javadoc() {
        if (this.m_aJavaDoc == null) {
            this.m_aJavaDoc = new JDocComment(this.owner());
        }
        return this.m_aJavaDoc;
    }

    @Nullable
    public JDocComment javadocOrNull() {
        return this.m_aJavaDoc;
    }

    public void remove(@Nonnull AbstractJClass abstractJClass) {
        JCValueEnforcer.isTrue(abstractJClass._package() == this, () -> "the specified class (" + abstractJClass.fullName() + ") is not a member of this package (" + this.name() + "), or it is a referenced class");
        this.m_aClasses.remove(abstractJClass.name());
        if (this.m_aUpperCaseClassMap != null) {
            this.m_aUpperCaseClassMap.remove(abstractJClass.name().toUpperCase());
        }
    }

    @Nonnull
    public AbstractJClass ref(@Nonnull String string) throws ClassNotFoundException {
        JCValueEnforcer.isTrue(string.indexOf(46) < 0, () -> "JClass name contains '.': " + string);
        String string2 = this.isUnnamed() ? "" : this.m_sName + '.';
        string2 = string2 + string;
        return this.m_aOwner.ref(Class.forName(string2));
    }

    @Nonnull
    public JPackage subPackage(@Nonnull String string) {
        if (this.isUnnamed()) {
            return this.owner()._package(string);
        }
        return this.owner()._package(this.m_sName + '.' + string);
    }

    @Override
    @Nonnull
    public Collection<JDefinedClass> classes() {
        return this.m_aClasses.values();
    }

    public boolean isDefined(@Nullable String string) {
        for (JDefinedClass jDefinedClass : this.m_aClasses.values()) {
            if (!jDefinedClass.name().equals(string)) continue;
            return true;
        }
        return false;
    }

    public final boolean isUnnamed() {
        return this.m_sName.length() == 0;
    }

    @Nonnull
    public String name() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public final JCodeModel owner() {
        return this.m_aOwner;
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull AbstractJClass abstractJClass) {
        JCValueEnforcer.isFalse(this.isUnnamed(), "the root package cannot be annotated");
        if (this.m_aAnnotations == null) {
            this.m_aAnnotations = new ArrayList<JAnnotationUse>();
        }
        JAnnotationUse jAnnotationUse = new JAnnotationUse(abstractJClass);
        this.m_aAnnotations.add(jAnnotationUse);
        return jAnnotationUse;
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull Class<? extends Annotation> clazz) {
        return this.annotate(this.m_aOwner.ref(clazz));
    }

    @Override
    @Nonnull
    public Collection<JAnnotationUse> annotations() {
        if (this.m_aAnnotations == null) {
            this.m_aAnnotations = new ArrayList<JAnnotationUse>();
        }
        return Collections.unmodifiableList(this.m_aAnnotations);
    }

    @Nonnull
    File toPath(@Nonnull File file) {
        if (this.m_sName == null) {
            return file;
        }
        return new File(file, this.m_sName.replace('.', File.separatorChar));
    }

    @Override
    public void declare(@Nonnull IJFormatter iJFormatter) {
        if (this.m_sName.length() != 0) {
            iJFormatter.print("package").print(this.m_sName).print(';').newline();
        }
    }

    @Override
    public void generate(@Nonnull IJFormatter iJFormatter) {
        iJFormatter.print(this.m_sName);
    }

    boolean buildsErrorTypeRefs() {
        for (JDefinedClass jDefinedClass : this.m_aClasses.values()) {
            if (jDefinedClass.isHidden() || !jDefinedClass.containsErrorTypes()) continue;
            return true;
        }
        return false;
    }

    int countArtifacts() {
        int n = 0;
        for (JDefinedClass jDefinedClass : this.m_aClasses.values()) {
            if (jDefinedClass.isHidden()) continue;
            ++n;
        }
        if (this.m_aAnnotations != null || this.m_aJavaDoc != null) {
            ++n;
        }
        return n += this.m_aResources.size();
    }
}

