/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCatchBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class JTryBlock
implements IJStatement {
    private final JBlock m_aBody = new JBlock();
    private final List<JCatchBlock> m_aCatches = new ArrayList<JCatchBlock>();
    private JBlock m_aFinally;

    @Nonnull
    public JBlock body() {
        return this.m_aBody;
    }

    @Nonnull
    public JCatchBlock _catch(@Nonnull AbstractJClass abstractJClass) {
        JCatchBlock jCatchBlock = new JCatchBlock(abstractJClass);
        this.m_aCatches.add(jCatchBlock);
        return jCatchBlock;
    }

    @Nonnull
    public List<JCatchBlock> catches() {
        return Collections.unmodifiableList(this.m_aCatches);
    }

    @Nonnull
    public JBlock _finally() {
        if (this.m_aFinally == null) {
            this.m_aFinally = new JBlock();
        }
        return this.m_aFinally;
    }

    @Override
    public void state(@Nonnull IJFormatter iJFormatter) {
        iJFormatter.print("try").generable(this.m_aBody);
        for (JCatchBlock jCatchBlock : this.m_aCatches) {
            iJFormatter.generable(jCatchBlock);
        }
        if (this.m_aFinally != null) {
            iJFormatter.print("finally").generable(this.m_aFinally);
        }
        iJFormatter.newline();
    }
}

