/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJDeclaration;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JJavaName;
import com.helger.jcodemodel.JMods;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JVar
implements IJAssignmentTarget,
IJDeclaration,
IJAnnotatable {
    private final JMods m_aMods;
    private AbstractJType m_aType;
    private String m_sName;
    private IJExpression m_aInitExpr;
    private List<JAnnotationUse> m_aAnnotations;

    public JVar(@Nonnull JMods jMods, @Nonnull AbstractJType abstractJType, @Nonnull String string, @Nullable IJExpression iJExpression) {
        JCValueEnforcer.isTrue(JJavaName.isJavaIdentifier(string), () -> "Illegal variable name '" + string + "'");
        this.m_aMods = jMods;
        this.m_aType = abstractJType;
        this.m_sName = string;
        this.m_aInitExpr = iJExpression;
    }

    @Nonnull
    public JVar init(@Nullable IJExpression iJExpression) {
        this.m_aInitExpr = iJExpression;
        return this;
    }

    @Nullable
    public IJExpression init() {
        return this.m_aInitExpr;
    }

    @Nonnull
    public String name() {
        return this.m_sName;
    }

    public void name(@Nonnull String string) {
        JCValueEnforcer.isTrue(JJavaName.isJavaIdentifier(string), () -> "Illegal variable name '" + string + "'");
        this.m_sName = string;
    }

    @Nonnull
    public AbstractJType type() {
        return this.m_aType;
    }

    @Nonnull
    public JMods mods() {
        return this.m_aMods;
    }

    @Nonnull
    public AbstractJType type(@Nonnull AbstractJType abstractJType) {
        JCValueEnforcer.notNull(abstractJType, "NewType");
        AbstractJType abstractJType2 = this.m_aType;
        this.m_aType = abstractJType;
        return abstractJType2;
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull AbstractJClass abstractJClass) {
        if (this.m_aAnnotations == null) {
            this.m_aAnnotations = new ArrayList<JAnnotationUse>();
        }
        JAnnotationUse jAnnotationUse = new JAnnotationUse(abstractJClass);
        this.m_aAnnotations.add(jAnnotationUse);
        return jAnnotationUse;
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull Class<? extends Annotation> clazz) {
        return this.annotate(this.m_aType.owner().ref(clazz));
    }

    @Override
    @Nonnull
    public Collection<JAnnotationUse> annotations() {
        if (this.m_aAnnotations == null) {
            this.m_aAnnotations = new ArrayList<JAnnotationUse>();
        }
        return Collections.unmodifiableList(this.m_aAnnotations);
    }

    protected boolean isAnnotated() {
        return this.m_aAnnotations != null;
    }

    public void bind(@Nonnull IJFormatter iJFormatter) {
        if (this.m_aAnnotations != null) {
            boolean bl = this instanceof JFieldVar;
            for (JAnnotationUse jAnnotationUse : this.m_aAnnotations) {
                iJFormatter.generable(jAnnotationUse);
                if (bl) {
                    iJFormatter.newline();
                    continue;
                }
                iJFormatter.print(' ');
            }
        }
        iJFormatter.generable(this.m_aMods).generable(this.m_aType).id(this.m_sName);
        if (this.m_aInitExpr != null) {
            iJFormatter.print('=').generable(this.m_aInitExpr);
        }
    }

    @Override
    public void declare(@Nonnull IJFormatter iJFormatter) {
        iJFormatter.var(this).print(';').newline();
    }

    @Override
    public void generate(@Nonnull IJFormatter iJFormatter) {
        iJFormatter.id(this.m_sName);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JVar jVar = (JVar)object;
        return JCEqualsHelper.isEqual(this.m_sName, jVar.m_sName);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this.m_sName);
    }
}

