/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJAnnotationWriter;
import com.helger.jcodemodel.JAnnotationArrayMember;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.util.JCSecureLoader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TypedAnnotationWriter<A extends Annotation, W extends IJAnnotationWriter<A>>
implements InvocationHandler,
IJAnnotationWriter<A> {
    private final JAnnotationUse m_aUse;
    private final Class<A> m_aAnnotationType;
    private final Class<W> m_aWriterType;
    private Map<String, JAnnotationArrayMember> m_aArrays;

    protected TypedAnnotationWriter(Class<A> clazz, Class<W> clazz2, JAnnotationUse jAnnotationUse) {
        this.m_aAnnotationType = clazz;
        this.m_aWriterType = clazz2;
        this.m_aUse = jAnnotationUse;
    }

    @Override
    public JAnnotationUse getAnnotationUse() {
        return this.m_aUse;
    }

    @Override
    public Class<A> getAnnotationType() {
        return this.m_aAnnotationType;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Method method2;
        Class<?> clazz;
        if (method.getDeclaringClass() == IJAnnotationWriter.class) {
            try {
                return method.invoke((Object)this, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
        String string = method.getName();
        Object object2 = null;
        if (objectArray != null && objectArray.length > 0) {
            object2 = objectArray[0];
        }
        if ((clazz = (method2 = this.m_aAnnotationType.getDeclaredMethod(string, new Class[0])).getReturnType()).isArray()) {
            return this._addArrayValue(object, string, clazz.getComponentType(), method.getReturnType(), object2);
        }
        if (Annotation.class.isAssignableFrom(clazz)) {
            Class<?> clazz2 = clazz;
            return super._createProxy();
        }
        if (object2 instanceof AbstractJType) {
            AbstractJType abstractJType = (AbstractJType)object2;
            this._checkType(Class.class, clazz);
            if (method2.getDefaultValue() != null && abstractJType.equals(abstractJType.owner().ref((Class)method2.getDefaultValue()))) {
                return object;
            }
            this.m_aUse.param(string, abstractJType);
            return object;
        }
        this._checkType(object2.getClass(), clazz);
        if (method2.getDefaultValue() != null && method2.getDefaultValue().equals(object2)) {
            return object;
        }
        if (object2 instanceof String) {
            this.m_aUse.param(string, (String)object2);
            return object;
        }
        if (object2 instanceof Boolean) {
            this.m_aUse.param(string, (Boolean)object2);
            return object;
        }
        if (object2 instanceof Integer) {
            this.m_aUse.param(string, (Integer)object2);
            return object;
        }
        if (object2 instanceof Class) {
            this.m_aUse.param(string, (Class)object2);
            return object;
        }
        if (object2 instanceof Enum) {
            this.m_aUse.param(string, (Enum)object2);
            return object;
        }
        throw new IllegalArgumentException("Unable to handle this method call " + method.toString());
    }

    private Object _addArrayValue(Object object, String string2, Class<?> clazz, Class<?> clazz2, Object object2) {
        if (this.m_aArrays == null) {
            this.m_aArrays = new HashMap<String, JAnnotationArrayMember>();
        }
        JAnnotationArrayMember jAnnotationArrayMember = this.m_aArrays.computeIfAbsent(string2, string -> this.m_aUse.paramArray((String)string));
        if (Annotation.class.isAssignableFrom(clazz)) {
            Class<?> clazz3 = clazz;
            if (!IJAnnotationWriter.class.isAssignableFrom(clazz2)) {
                throw new IllegalArgumentException("Unexpected return type " + clazz2);
            }
            return super._createProxy();
        }
        if (object2 instanceof AbstractJType) {
            this._checkType(Class.class, clazz);
            jAnnotationArrayMember.param((AbstractJType)object2);
            return object;
        }
        this._checkType(object2.getClass(), clazz);
        if (object2 instanceof String) {
            jAnnotationArrayMember.param((String)object2);
            return object;
        }
        if (object2 instanceof Boolean) {
            jAnnotationArrayMember.param((Boolean)object2);
            return object;
        }
        if (object2 instanceof Integer) {
            jAnnotationArrayMember.param((Integer)object2);
            return object;
        }
        if (object2 instanceof Class) {
            jAnnotationArrayMember.param((Class)object2);
            return object;
        }
        throw new IllegalArgumentException("Unable to handle this method call ");
    }

    private void _checkType(Class<?> clazz, Class<?> clazz2) {
        if (clazz2 == clazz || clazz2.isAssignableFrom(clazz)) {
            return;
        }
        if (clazz2 == JCodeModel.boxToPrimitive.get(clazz)) {
            return;
        }
        throw new IllegalArgumentException("Expected " + clazz2 + " but found " + clazz);
    }

    private W _createProxy() {
        return (W)((IJAnnotationWriter)Proxy.newProxyInstance(JCSecureLoader.getClassClassLoader(this.m_aWriterType), new Class[]{this.m_aWriterType}, (InvocationHandler)this));
    }

    @Nonnull
    static <W extends IJAnnotationWriter<?>> W create(@Nonnull Class<W> clazz, @Nonnull IJAnnotatable iJAnnotatable) {
        Class<Annotation> clazz2 = TypedAnnotationWriter._findAnnotationType(clazz);
        return super._createProxy();
    }

    @Nullable
    private static Class<? extends Annotation> _findAnnotationType(@Nonnull Class<?> clazz) {
        for (Type type : clazz.getGenericInterfaces()) {
            Type type2;
            if (type instanceof ParameterizedType && (type2 = (ParameterizedType)type).getRawType() == IJAnnotationWriter.class) {
                return (Class)type2.getActualTypeArguments()[0];
            }
            if (!(type instanceof Class) || (type2 = TypedAnnotationWriter._findAnnotationType((Class)type)) == null) continue;
            return type2;
        }
        return null;
    }
}

