/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.meta;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.EClassType;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.meta.ClassFiller;
import com.helger.jcodemodel.meta.CodeModelBuildingException;
import com.helger.jcodemodel.meta.ErrorTypeFound;
import com.helger.jcodemodel.meta.ErrorTypePolicy;
import com.helger.jcodemodel.meta.RuntimeCodeModelBuildingException;
import com.helger.jcodemodel.meta.RuntimeErrorTypeFound;
import com.helger.jcodemodel.meta.TypeEnvironment;
import com.helger.jcodemodel.meta.TypeMirrorToJTypeVisitor;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

class DecidedErrorTypesModelsAdapter {
    private static final Logger LOGGER = Logger.getLogger(DecidedErrorTypesModelsAdapter.class.getName());
    private final Elements m_aElementUtils;
    private final ErrorTypePolicy m_aErrorTypePolicy;
    private final JCodeModel m_aCodeModel;

    static int toJMod(Collection<Modifier> collection) {
        int n = 0;
        block13: for (Modifier modifier : collection) {
            switch (modifier) {
                case ABSTRACT: {
                    n |= 0x20;
                    continue block13;
                }
                case FINAL: {
                    n |= 8;
                    continue block13;
                }
                case NATIVE: {
                    n |= 0x40;
                    continue block13;
                }
                case PRIVATE: {
                    n |= 4;
                    continue block13;
                }
                case PROTECTED: {
                    n |= 2;
                    continue block13;
                }
                case PUBLIC: {
                    n |= 1;
                    continue block13;
                }
                case STATIC: {
                    n |= 0x10;
                    continue block13;
                }
                case SYNCHRONIZED: {
                    n |= 0x80;
                    continue block13;
                }
                case TRANSIENT: {
                    n |= 0x100;
                    continue block13;
                }
                case VOLATILE: {
                    n |= 0x200;
                    continue block13;
                }
                case STRICTFP: {
                    n |= 0x800;
                    continue block13;
                }
            }
            LOGGER.log(Level.WARNING, "Skpping unsupported modifier: {0}", (Object)modifier);
        }
        return n;
    }

    private static EClassType _toClassType(@Nonnull ElementKind elementKind) {
        switch (elementKind) {
            case CLASS: {
                return EClassType.CLASS;
            }
            case ENUM: {
                return EClassType.ENUM;
            }
            case INTERFACE: {
                return EClassType.INTERFACE;
            }
            case ANNOTATION_TYPE: {
                return EClassType.ANNOTATION_TYPE_DECL;
            }
        }
        throw new UnsupportedOperationException("Unsupported ElementKind: " + (Object)((Object)elementKind));
    }

    DecidedErrorTypesModelsAdapter(JCodeModel jCodeModel, Elements elements, ErrorTypePolicy errorTypePolicy) {
        this.m_aElementUtils = elements;
        this.m_aErrorTypePolicy = errorTypePolicy;
        this.m_aCodeModel = jCodeModel;
    }

    public JDefinedClass getClass(TypeElement typeElement) throws CodeModelBuildingException, ErrorTypeFound {
        Element element = typeElement.getEnclosingElement();
        if (element instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)element;
            JPackage jPackage = this.m_aCodeModel._package(packageElement.getQualifiedName().toString());
            JDefinedClass jDefinedClass = jPackage._getClass(typeElement.getSimpleName().toString());
            if (jDefinedClass != null) {
                return jDefinedClass;
            }
            JDefinedClass jDefinedClass2 = this._defineClass(typeElement);
            jDefinedClass2.hide();
            return jDefinedClass2;
        }
        if (element instanceof TypeElement) {
            JDefinedClass jDefinedClass = this.getClass((TypeElement)element);
            for (JDefinedClass jDefinedClass3 : jDefinedClass.classes()) {
                String string = jDefinedClass3.fullName();
                if (string == null || !string.equals(typeElement.getQualifiedName().toString())) continue;
                return jDefinedClass3;
            }
            throw new CodeModelBuildingException("Can't define inner class " + typeElement.getQualifiedName() + ": enclosing class " + jDefinedClass.fullName() + " already defined", new JClassAlreadyExistsException(jDefinedClass));
        }
        throw new IllegalStateException("Enclosing element should be package or class");
    }

    private JDefinedClass _defineClass(TypeElement typeElement) throws CodeModelBuildingException, ErrorTypeFound {
        Element element = typeElement.getEnclosingElement();
        if (element instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)element;
            return this._defineTopLevelClass(typeElement, new TypeEnvironment(packageElement.getQualifiedName().toString()));
        }
        return this.getClass(typeElement);
    }

    private JDefinedClass _defineTopLevelClass(TypeElement typeElement, TypeEnvironment typeEnvironment) throws CodeModelBuildingException, ErrorTypeFound {
        JDefinedClass jDefinedClass;
        Element element;
        EClassType eClassType = DecidedErrorTypesModelsAdapter._toClassType(typeElement.getKind());
        int n = DecidedErrorTypesModelsAdapter.toJMod(typeElement.getModifiers());
        if (eClassType.equals((Object)EClassType.INTERFACE)) {
            n &= 0xFFFFFFDF;
            n &= 0xFFFFFFEF;
        }
        if (!((element = typeElement.getEnclosingElement()) instanceof PackageElement)) {
            throw new IllegalStateException("Expecting top level class");
        }
        PackageElement packageElement = (PackageElement)element;
        JPackage jPackage = this.m_aCodeModel._package(packageElement.getQualifiedName().toString());
        try {
            jDefinedClass = jPackage._class(n, typeElement.getSimpleName().toString(), eClassType);
        }
        catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
            throw new CodeModelBuildingException(jClassAlreadyExistsException);
        }
        this._declareInnerClasses(jDefinedClass, typeElement, typeEnvironment);
        ClassFiller classFiller = new ClassFiller(this.m_aCodeModel, this, jDefinedClass);
        classFiller.fillClass(typeElement, typeEnvironment);
        return jDefinedClass;
    }

    private void _declareInnerClasses(JDefinedClass jDefinedClass, TypeElement typeElement, TypeEnvironment typeEnvironment) throws CodeModelBuildingException {
        for (Element element : typeElement.getEnclosedElements()) {
            JDefinedClass jDefinedClass2;
            if (!element.getKind().equals((Object)ElementKind.INTERFACE) && !element.getKind().equals((Object)ElementKind.CLASS) && !element.getKind().equals((Object)ElementKind.ENUM) && !element.getKind().equals((Object)ElementKind.ANNOTATION_TYPE)) continue;
            EClassType eClassType = DecidedErrorTypesModelsAdapter._toClassType(element.getKind());
            int n = DecidedErrorTypesModelsAdapter.toJMod(element.getModifiers());
            if (eClassType.equals((Object)EClassType.INTERFACE) || eClassType.equals((Object)EClassType.ANNOTATION_TYPE_DECL)) {
                n &= 0xFFFFFFDF;
            }
            if (eClassType.equals((Object)EClassType.INTERFACE) || eClassType.equals((Object)EClassType.ENUM) || eClassType.equals((Object)EClassType.ANNOTATION_TYPE_DECL)) {
                n &= 0xFFFFFFEF;
            }
            if (eClassType.equals((Object)EClassType.ENUM)) {
                n &= 0xFFFFFFF7;
            }
            try {
                jDefinedClass2 = (JDefinedClass)jDefinedClass._class(n, element.getSimpleName().toString(), eClassType);
            }
            catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
                throw new CodeModelBuildingException(jClassAlreadyExistsException);
            }
            this._declareInnerClasses(jDefinedClass2, (TypeElement)element, typeEnvironment);
        }
    }

    void defineInnerClass(JDefinedClass jDefinedClass, TypeElement typeElement, TypeEnvironment typeEnvironment) throws CodeModelBuildingException, ErrorTypeFound {
        for (JDefinedClass jDefinedClass2 : jDefinedClass.classes()) {
            String string = jDefinedClass2.fullName();
            if (string == null || !string.equals(typeElement.getQualifiedName().toString())) continue;
            ClassFiller classFiller = new ClassFiller(this.m_aCodeModel, this, jDefinedClass2);
            classFiller.fillClass(typeElement, typeEnvironment);
            return;
        }
        throw new IllegalStateException("Inner class should always be defined if outer class is defined: inner class " + typeElement + ", enclosing class " + jDefinedClass);
    }

    AbstractJClass ref(TypeElement typeElement) throws CodeModelBuildingException, ErrorTypeFound {
        try {
            Class<?> clazz = Class.forName(typeElement.getQualifiedName().toString());
            AbstractJClass abstractJClass = this.m_aCodeModel.ref(clazz);
            return abstractJClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.getClass(typeElement);
        }
    }

    AbstractJType toJType(TypeMirror typeMirror, TypeEnvironment typeEnvironment) throws CodeModelBuildingException, ErrorTypeFound {
        try {
            return typeMirror.accept(new TypeMirrorToJTypeVisitor(this.m_aCodeModel, this, this.m_aErrorTypePolicy, typeEnvironment), null);
        }
        catch (RuntimeErrorTypeFound runtimeErrorTypeFound) {
            throw runtimeErrorTypeFound.getCause();
        }
        catch (RuntimeCodeModelBuildingException runtimeCodeModelBuildingException) {
            throw runtimeCodeModelBuildingException.getCause();
        }
    }

    Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror annotationMirror) {
        return this.m_aElementUtils.getElementValuesWithDefaults(annotationMirror);
    }
}

