/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.writer;

import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.writer.AbstractCodeWriter;
import com.helger.jcodemodel.writer.JCMWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileCodeWriter
extends AbstractCodeWriter {
    public static final boolean DEFAULT_MARK_READ_ONLY = false;
    public static final Charset DEFAULT_CHARSET = null;
    private final File m_aTargetDir;
    private final boolean m_bMarkReadOnly;
    private final Set<File> m_aReadOnlyFiles = new HashSet<File>();

    public FileCodeWriter(@Nonnull File file) throws IOException {
        this(file, false, DEFAULT_CHARSET, JCMWriter.getDefaultNewLine());
    }

    public FileCodeWriter(@Nonnull File file, @Nullable Charset charset) throws IOException {
        this(file, false, charset, JCMWriter.getDefaultNewLine());
    }

    public FileCodeWriter(@Nonnull File file, boolean bl) throws IOException {
        this(file, bl, DEFAULT_CHARSET, JCMWriter.getDefaultNewLine());
    }

    public FileCodeWriter(@Nonnull File file, @Nullable Charset charset, @Nonnull String string) throws IOException {
        this(file, false, charset, string);
    }

    public FileCodeWriter(@Nonnull File file, boolean bl, @Nullable Charset charset) throws IOException {
        this(file, bl, charset, JCMWriter.getDefaultNewLine());
    }

    public FileCodeWriter(@Nonnull File file, boolean bl, @Nullable Charset charset, @Nonnull String string) throws IOException {
        super(charset, string);
        this.m_aTargetDir = file;
        this.m_bMarkReadOnly = bl;
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException(file + ": non-existent directory");
        }
    }

    @Override
    @Nonnull
    public OutputStream openBinary(@Nonnull JPackage jPackage, @Nonnull String string) throws IOException {
        return new FileOutputStream(this.getFile(jPackage, string));
    }

    @Nonnull
    protected File getFile(@Nonnull JPackage jPackage, @Nonnull String string) throws IOException {
        File file = jPackage.isUnnamed() ? this.m_aTargetDir : new File(this.m_aTargetDir, FileCodeWriter._toDirName(jPackage));
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException(file + ": failed to create directory");
        }
        File file2 = new File(file, string);
        if (file2.exists() && !file2.delete()) {
            throw new IOException(file2 + ": Can't delete previous version");
        }
        if (this.m_bMarkReadOnly) {
            this.m_aReadOnlyFiles.add(file2);
        }
        return file2;
    }

    @Override
    public void close() throws IOException {
        for (File file : this.m_aReadOnlyFiles) {
            if (file.setReadOnly()) continue;
            throw new IOException(file + ": Can't make file read-only");
        }
    }

    @Nonnull
    private static String _toDirName(@Nonnull JPackage jPackage) {
        return jPackage.name().replace('.', File.separatorChar);
    }
}

