/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.writer;

import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JDocComment;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.SourcePrintWriter;
import com.helger.jcodemodel.fmt.AbstractJResourceFile;
import com.helger.jcodemodel.util.JCValueEnforcer;
import com.helger.jcodemodel.writer.AbstractCodeWriter;
import com.helger.jcodemodel.writer.FileCodeWriter;
import com.helger.jcodemodel.writer.JFormatter;
import com.helger.jcodemodel.writer.ProgressCodeWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JCMWriter {
    public static final String DEFAULT_INDENT_STRING = "    ";
    private static String s_sDefaultNewLine;
    private final JCodeModel m_aCM;
    private Charset m_aCharset = StandardCharsets.UTF_8;
    private String m_sNewLine = JCMWriter.getDefaultNewLine();
    private String m_sIndentString = "    ";

    @Nonnull
    public static String getDefaultNewLine() {
        String string = s_sDefaultNewLine;
        if (string == null) {
            try {
                string = s_sDefaultNewLine = System.getProperty("line.separator");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string == null || string.length() == 0) {
                s_sDefaultNewLine = "\n";
                string = "\n";
            }
        }
        return string;
    }

    public JCMWriter(@Nonnull JCodeModel jCodeModel) {
        this.m_aCM = jCodeModel;
    }

    @Nullable
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    public JCMWriter setCharset(@Nullable Charset charset) {
        this.m_aCharset = charset;
        return this;
    }

    @Nonnull
    public String getNewLine() {
        return this.m_sNewLine;
    }

    @Nonnull
    public JCMWriter setNewLine(@Nonnull String string) {
        JCValueEnforcer.notEmpty(string, "NewLine");
        this.m_sNewLine = string;
        return this;
    }

    @Nonnull
    public String getIndentString() {
        return this.m_sIndentString;
    }

    @Nonnull
    public JCMWriter setIndentString(@Nonnull String string) {
        JCValueEnforcer.notNull(string, "IndentString");
        this.m_sIndentString = string;
        return this;
    }

    public void build(@Nonnull File file, @Nullable ProgressCodeWriter.IProgressTracker iProgressTracker) throws IOException {
        this.build(file, file, iProgressTracker);
    }

    public void build(@Nonnull File file, @Nonnull File file2, @Nullable ProgressCodeWriter.IProgressTracker iProgressTracker) throws IOException {
        AbstractCodeWriter abstractCodeWriter = new FileCodeWriter(file, this.m_aCharset, this.m_sNewLine);
        AbstractCodeWriter abstractCodeWriter2 = new FileCodeWriter(file2, this.m_aCharset, this.m_sNewLine);
        if (iProgressTracker != null) {
            abstractCodeWriter = new ProgressCodeWriter(abstractCodeWriter, iProgressTracker);
            abstractCodeWriter2 = new ProgressCodeWriter(abstractCodeWriter2, iProgressTracker);
        }
        this.build(abstractCodeWriter, abstractCodeWriter2);
    }

    public void build(@Nonnull File file) throws IOException {
        this.build(file, System.out::println);
    }

    public void build(@Nonnull File file, @Nonnull File file2) throws IOException {
        this.build(file, file2, System.out::println);
    }

    public void build(@Nonnull AbstractCodeWriter abstractCodeWriter) throws IOException {
        this.build(abstractCodeWriter, abstractCodeWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(@Nonnull AbstractCodeWriter abstractCodeWriter, @Nonnull AbstractCodeWriter abstractCodeWriter2) throws IOException {
        try {
            List<JPackage> list = this.m_aCM.getAllPackages();
            for (JPackage jPackage : list) {
                this.buildPackage(abstractCodeWriter, abstractCodeWriter2, jPackage);
            }
        }
        finally {
            abstractCodeWriter.close();
            abstractCodeWriter2.close();
        }
    }

    @Nonnull
    private JFormatter _createJavaSourceFileWriter(@Nonnull AbstractCodeWriter abstractCodeWriter, @Nonnull JPackage jPackage, @Nonnull String string) throws IOException {
        SourcePrintWriter sourcePrintWriter = abstractCodeWriter.openSource(jPackage, string + ".java");
        JFormatter jFormatter = new JFormatter(sourcePrintWriter, this.m_sIndentString);
        jFormatter.addDontImportClasses(this.m_aCM.getAllDontImportClasses());
        return jFormatter;
    }

    public void buildPackage(@Nonnull AbstractCodeWriter abstractCodeWriter, @Nonnull AbstractCodeWriter abstractCodeWriter2, @Nonnull JPackage jPackage) throws IOException {
        Object object;
        Object object2;
        Object object3;
        for (JDefinedClass iJGenerable2 : jPackage.classes()) {
            if (iJGenerable2.isHidden()) continue;
            object3 = this._createJavaSourceFileWriter(abstractCodeWriter, jPackage, iJGenerable2.name());
            Throwable throwable = null;
            try {
                ((JFormatter)object3).writeClassFull(iJGenerable2);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            finally {
                if (object3 == null) continue;
                if (throwable != null) {
                    try {
                        ((JFormatter)object3).close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    continue;
                }
                ((JFormatter)object3).close();
            }
        }
        Collection<JAnnotationUse> collection = jPackage.annotations();
        JDocComment jDocComment = jPackage.javadoc();
        if (!collection.isEmpty() || !jDocComment.isEmpty()) {
            object3 = this._createJavaSourceFileWriter(abstractCodeWriter, jPackage, "package-info");
            Throwable throwable = null;
            try {
                if (!jDocComment.isEmpty()) {
                    object3.generable(jDocComment);
                }
                object2 = collection.iterator();
                while (object2.hasNext()) {
                    object = (JAnnotationUse)object2.next();
                    object3.generable((IJGenerable)object).newline();
                }
                object3.declaration(jPackage);
            }
            catch (Throwable throwable5) {
                Throwable throwable6 = throwable5;
                throw throwable5;
            }
            finally {
                if (object3 != null) {
                    if (throwable != null) {
                        try {
                            object3.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        object3.close();
                    }
                }
            }
        }
        for (AbstractJResourceFile abstractJResourceFile : jPackage.getAllResourceFiles()) {
            object2 = abstractJResourceFile.isResource() ? abstractCodeWriter2 : abstractCodeWriter;
            object = new BufferedOutputStream(((AbstractCodeWriter)object2).openBinary(jPackage, abstractJResourceFile.name()));
            Throwable throwable = null;
            try {
                abstractJResourceFile.build((OutputStream)object);
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (object == null) continue;
                if (throwable != null) {
                    try {
                        ((OutputStream)object).close();
                    }
                    catch (Throwable throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                    continue;
                }
                ((OutputStream)object).close();
            }
        }
    }
}

