/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.writer;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJDeclaration;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAnonymousClass;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JNarrowedClass;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.JVar;
import com.helger.jcodemodel.SourcePrintWriter;
import com.helger.jcodemodel.util.ClassNameComparator;
import com.helger.jcodemodel.util.JCValueEnforcer;
import com.helger.jcodemodel.util.NullWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class JFormatter
implements IJFormatter {
    private final Map<String, NameUsage> m_aCollectedReferences = new HashMap<String, NameUsage>();
    private final ImportedClasses m_aImportedClasses = new ImportedClasses();
    private EMode m_eMode = EMode.PRINTING;
    private int m_nIndentLevel;
    private final String m_sIndentString;
    private final SourcePrintWriter m_aPW;
    private char m_cLastChar = '\u0000';
    private boolean m_bAtBeginningOfLine = true;
    private JPackage m_aPckJavaLang;
    private boolean m_bContainsErrorTypes;
    private boolean m_bDebugImport = false;

    public JFormatter(@Nonnull SourcePrintWriter sourcePrintWriter, @Nonnull String string) {
        JCValueEnforcer.notNull(sourcePrintWriter, "PrintWriter");
        JCValueEnforcer.notNull(string, "IndentString");
        this.m_aPW = sourcePrintWriter;
        this.m_sIndentString = string;
    }

    public void setDebugImports(boolean bl) {
        this.m_bDebugImport = bl;
    }

    public boolean isDebugImports() {
        return this.m_bDebugImport;
    }

    @Override
    public void close() {
        this.m_aPW.close();
    }

    @Override
    public boolean isPrinting() {
        return this.m_eMode == EMode.PRINTING;
    }

    @Override
    @Nonnull
    public JFormatter indent() {
        ++this.m_nIndentLevel;
        return this;
    }

    @Override
    @Nonnull
    public JFormatter outdent() {
        --this.m_nIndentLevel;
        return this;
    }

    private static boolean _needSpace(char c, char c2) {
        if (c == ']' && c2 == '{') {
            return true;
        }
        if (c == ';') {
            return true;
        }
        if (c == '\uffff') {
            return c2 != '(';
        }
        if (c == ')' && c2 == '{') {
            return true;
        }
        if (c == ',' || c == '=') {
            return true;
        }
        if (c2 == '=') {
            return true;
        }
        if (Character.isDigit(c)) {
            return c2 != '(' && c2 != ')' && c2 != ';' && c2 != ',';
        }
        if (Character.isJavaIdentifierPart(c)) {
            switch (c2) {
                case '+': 
                case '-': 
                case '>': 
                case '@': 
                case '{': 
                case '}': {
                    return true;
                }
            }
            return Character.isJavaIdentifierStart(c2);
        }
        if (Character.isJavaIdentifierStart(c2)) {
            switch (c) {
                case ')': 
                case '+': 
                case ']': 
                case '}': {
                    return true;
                }
            }
            return false;
        }
        if (Character.isDigit(c2)) {
            return c != '(';
        }
        return false;
    }

    private void _spaceIfNeeded(char c) {
        if (this.m_bAtBeginningOfLine) {
            for (int i = 0; i < this.m_nIndentLevel; ++i) {
                this.m_aPW.print(this.m_sIndentString);
            }
            this.m_bAtBeginningOfLine = false;
        } else if (this.m_cLastChar != '\u0000' && JFormatter._needSpace(this.m_cLastChar, c)) {
            this.m_aPW.print(' ');
        }
    }

    @Override
    @Nonnull
    public JFormatter print(char c) {
        if (this.m_eMode == EMode.PRINTING) {
            if (c == '\uffff') {
                this.m_aPW.print('>');
            } else {
                this._spaceIfNeeded(c);
                this.m_aPW.print(c);
            }
            this.m_cLastChar = c;
        }
        return this;
    }

    @Override
    @Nonnull
    public JFormatter print(@Nonnull String string) {
        if (this.m_eMode == EMode.PRINTING && string.length() > 0) {
            this._spaceIfNeeded(string.charAt(0));
            this.m_aPW.print(string);
            this.m_cLastChar = string.charAt(string.length() - 1);
        }
        return this;
    }

    @Override
    @Nonnull
    public JFormatter type(@Nonnull AbstractJClass abstractJClass) {
        switch (this.m_eMode) {
            case COLLECTING: {
                if (abstractJClass.isError()) break;
                String string = abstractJClass.name();
                NameUsage nameUsage = this.m_aCollectedReferences.get(string);
                if (nameUsage == null) {
                    nameUsage = new NameUsage(string);
                    this.m_aCollectedReferences.put(string, nameUsage);
                }
                nameUsage.addReferencedType(abstractJClass);
                break;
            }
            case PRINTING: {
                if (abstractJClass.isError()) {
                    this.print("Object");
                    break;
                }
                if (this.m_aImportedClasses.contains(abstractJClass) || abstractJClass._package() == this.m_aPckJavaLang) {
                    this.print(abstractJClass.name());
                    break;
                }
                AbstractJClass abstractJClass2 = abstractJClass.outer();
                if (abstractJClass2 != null) {
                    this.type(abstractJClass2).print('.').print(abstractJClass.name());
                    break;
                }
                this.print(abstractJClass.fullName());
                break;
            }
            case FIND_ERROR_TYPES: {
                if (!abstractJClass.isError()) break;
                this.m_bContainsErrorTypes = true;
            }
        }
        return this;
    }

    @Override
    @Nonnull
    public JFormatter id(@Nonnull String string) {
        switch (this.m_eMode) {
            case COLLECTING: {
                NameUsage nameUsage = this.m_aCollectedReferences.get(string);
                if (nameUsage == null) {
                    nameUsage = new NameUsage(string);
                    this.m_aCollectedReferences.put(string, nameUsage);
                }
                nameUsage.setVariableName();
                break;
            }
            case PRINTING: {
                this.print(string);
            }
        }
        return this;
    }

    @Override
    @Nonnull
    public JFormatter newline() {
        if (this.m_eMode == EMode.PRINTING) {
            this.m_aPW.println();
            this.m_cLastChar = '\u0000';
            this.m_bAtBeginningOfLine = true;
        }
        return this;
    }

    @Override
    @Nonnull
    public JFormatter generable(@Nonnull IJGenerable iJGenerable) {
        iJGenerable.generate(this);
        return this;
    }

    @Override
    @Nonnull
    public JFormatter generable(@Nonnull Collection<? extends IJGenerable> collection) {
        if (!collection.isEmpty()) {
            boolean bl = true;
            for (IJGenerable iJGenerable : collection) {
                if (!bl) {
                    this.print(',');
                }
                this.generable(iJGenerable);
                bl = false;
            }
        }
        return this;
    }

    @Override
    @Nonnull
    public JFormatter declaration(@Nonnull IJDeclaration iJDeclaration) {
        iJDeclaration.declare(this);
        return this;
    }

    @Override
    @Nonnull
    public JFormatter statement(@Nonnull IJStatement iJStatement) {
        iJStatement.state(this);
        return this;
    }

    @Override
    @Nonnull
    public JFormatter var(@Nonnull JVar jVar) {
        jVar.bind(this);
        return this;
    }

    private boolean _collectCausesNoAmbiguities(@Nonnull AbstractJClass abstractJClass, @Nonnull JDefinedClass jDefinedClass) {
        NameUsage nameUsage;
        if (this.m_bDebugImport) {
            System.out.println("_collectCausesNoAmbiguities(" + abstractJClass.fullName() + ", " + jDefinedClass.fullName() + ")");
        }
        if ((nameUsage = this.m_aCollectedReferences.get(abstractJClass.name())) == null) {
            return true;
        }
        return !nameUsage.isAmbiguousIn(jDefinedClass) && nameUsage.containsReferencedType(abstractJClass);
    }

    private boolean _collectShouldBeImported(@Nonnull AbstractJClass abstractJClass, @Nonnull JDefinedClass jDefinedClass) {
        AbstractJClass abstractJClass2;
        AbstractJClass abstractJClass3;
        if (this.m_bDebugImport) {
            System.out.println("_collectShouldBeImported(" + abstractJClass.fullName() + ", " + jDefinedClass.fullName() + ")");
        }
        if ((abstractJClass3 = abstractJClass) instanceof JAnonymousClass) {
            abstractJClass3 = ((JAnonymousClass)abstractJClass3).base();
        }
        if (abstractJClass3 instanceof JNarrowedClass) {
            abstractJClass3 = abstractJClass3.erasure();
        }
        if ((abstractJClass2 = abstractJClass3.outer()) != null) {
            return abstractJClass3.name().contains(abstractJClass2.name()) && this._collectShouldBeImported(abstractJClass2, jDefinedClass);
        }
        return true;
    }

    private void _collectImportOuterClassIfCausesNoAmbiguities(@Nonnull AbstractJClass abstractJClass, @Nonnull JDefinedClass jDefinedClass) {
        AbstractJClass abstractJClass2;
        if (this.m_bDebugImport) {
            System.out.println("_collectImportOuterClassIfCausesNoAmbiguities(" + abstractJClass.fullName() + ", " + jDefinedClass.fullName() + ")");
        }
        if ((abstractJClass2 = abstractJClass.outer()) != null) {
            if (this._collectCausesNoAmbiguities(abstractJClass2, jDefinedClass) && this._collectShouldBeImported(abstractJClass2, jDefinedClass)) {
                this.m_aImportedClasses.add(abstractJClass2);
            } else {
                this._collectImportOuterClassIfCausesNoAmbiguities(abstractJClass2, jDefinedClass);
            }
        }
    }

    private boolean _printIsImplicitlyImported(@Nonnull AbstractJClass abstractJClass, @Nonnull AbstractJClass abstractJClass2) {
        JPackage jPackage;
        AbstractJClass abstractJClass3;
        if (this.m_bDebugImport) {
            System.out.println("_printIsImplicitlyImported(" + abstractJClass.fullName() + ", " + abstractJClass2.fullName() + ")");
        }
        if ((abstractJClass3 = abstractJClass) instanceof JAnonymousClass) {
            abstractJClass3 = ((JAnonymousClass)abstractJClass3).base();
        }
        if (abstractJClass3 instanceof JNarrowedClass) {
            abstractJClass3 = abstractJClass3.erasure();
        }
        if ((jPackage = abstractJClass3._package()) == null) {
            return true;
        }
        if (jPackage.isUnnamed()) {
            return true;
        }
        if (jPackage == this.m_aPckJavaLang) {
            return true;
        }
        if (jPackage == abstractJClass2._package()) {
            AbstractJClass abstractJClass4 = abstractJClass3.outer();
            if (abstractJClass4 == null) {
                return true;
            }
            AbstractJClass abstractJClass5 = abstractJClass4;
            abstractJClass4 = abstractJClass5.outer();
            while (abstractJClass4 != null) {
                abstractJClass5 = abstractJClass4;
                abstractJClass4 = abstractJClass5.outer();
            }
            return abstractJClass5 == abstractJClass2;
        }
        return false;
    }

    void writeClassFull(@Nonnull JDefinedClass jDefinedClass) {
        this.m_aPckJavaLang = jDefinedClass.owner()._package("java.lang");
        this.m_eMode = EMode.COLLECTING;
        this.m_aCollectedReferences.clear();
        this.m_aImportedClasses.clear();
        this.declaration(jDefinedClass);
        if (this.m_bDebugImport) {
            System.out.println("***Start collecting***");
        }
        this.m_aImportedClasses.add(jDefinedClass);
        Object object = this.m_aCollectedReferences.values().iterator();
        while (object.hasNext()) {
            NameUsage nameUsage = object.next();
            if (!nameUsage.isAmbiguousIn(jDefinedClass) && !nameUsage.isVariableName()) {
                AbstractJClass abstractJClass = nameUsage.getSingleReferencedType();
                if (this._collectShouldBeImported(abstractJClass, jDefinedClass)) {
                    this.m_aImportedClasses.add(abstractJClass);
                    continue;
                }
                this._collectImportOuterClassIfCausesNoAmbiguities(abstractJClass, jDefinedClass);
                continue;
            }
            if (!nameUsage.isTypeName()) continue;
            for (AbstractJClass abstractJClass : nameUsage.getReferencedTypes()) {
                this._collectImportOuterClassIfCausesNoAmbiguities(abstractJClass, jDefinedClass);
            }
        }
        if (this.m_bDebugImport) {
            System.out.println("***Finished collecting***");
        }
        this.m_eMode = EMode.PRINTING;
        assert (jDefinedClass.parentContainer().isPackage()) : "this method is only for a pacakge-level class";
        if (jDefinedClass.hasHeaderComment()) {
            this.generable(jDefinedClass.headerComment());
        }
        if (!((JPackage)(object = (JPackage)jDefinedClass.parentContainer())).isUnnamed()) {
            this.declaration((IJDeclaration)object).newline();
        }
        boolean bl = false;
        for (AbstractJClass abstractJClass : this.m_aImportedClasses.getAllSorted()) {
            if (this._printIsImplicitlyImported(abstractJClass, jDefinedClass)) continue;
            this.print("import").print(abstractJClass.fullName()).print(';').newline();
            bl = true;
            if (!this.m_bDebugImport) continue;
            System.out.println("  import " + abstractJClass.fullName());
        }
        if (bl) {
            this.newline();
        }
        this.declaration(jDefinedClass);
    }

    void addDontImportClasses(@Nullable Iterable<? extends AbstractJClass> iterable) {
        if (iterable != null) {
            for (AbstractJClass abstractJClass : iterable) {
                this.m_aImportedClasses.addDontImportClass(abstractJClass);
            }
        }
    }

    public static boolean containsErrorTypes(@Nonnull JDefinedClass jDefinedClass) {
        try (JFormatter jFormatter = new JFormatter(new SourcePrintWriter(NullWriter.getInstance(), "\n"), "\t");){
            jFormatter.m_eMode = EMode.FIND_ERROR_TYPES;
            jFormatter.m_bContainsErrorTypes = false;
            jFormatter.declaration(jDefinedClass);
            boolean bl = jFormatter.m_bContainsErrorTypes;
            return bl;
        }
    }

    private final class ImportedClasses {
        private final Set<AbstractJClass> m_aDontImportClasses = new HashSet<AbstractJClass>();
        private final Set<AbstractJClass> m_aClasses = new HashSet<AbstractJClass>();
        private final Set<String> m_aNames = new HashSet<String>();

        @Nullable
        private AbstractJClass _getClassForImport(@Nullable AbstractJClass abstractJClass) {
            AbstractJClass abstractJClass2 = abstractJClass;
            if (abstractJClass2 instanceof JAnonymousClass) {
                return this._getClassForImport(((JAnonymousClass)abstractJClass2).base());
            }
            if (abstractJClass2 instanceof JNarrowedClass) {
                abstractJClass2 = abstractJClass2.erasure();
            }
            return abstractJClass2;
        }

        public void addDontImportClass(@Nonnull AbstractJClass abstractJClass) {
            AbstractJClass abstractJClass2 = this._getClassForImport(abstractJClass);
            this.m_aDontImportClasses.add(abstractJClass2);
        }

        public boolean add(@Nonnull AbstractJClass abstractJClass) {
            AbstractJClass abstractJClass2 = this._getClassForImport(abstractJClass);
            if (this.m_aDontImportClasses.contains(abstractJClass2)) {
                if (JFormatter.this.m_bDebugImport) {
                    System.out.println("The class '" + abstractJClass2.fullName() + "' should not be imported!");
                }
                return false;
            }
            if (!this.m_aNames.add(abstractJClass2.name())) {
                if (JFormatter.this.m_bDebugImport) {
                    System.out.println("A class with local name '" + abstractJClass2.name() + "' is already in the import list.");
                }
                return false;
            }
            if (!this.m_aClasses.add(abstractJClass2)) {
                if (JFormatter.this.m_bDebugImport) {
                    System.out.println("The class '" + abstractJClass2.fullName() + "' is already in the import list.");
                }
                return false;
            }
            if (JFormatter.this.m_bDebugImport) {
                System.out.println("Added import class '" + abstractJClass.fullName() + "'");
            }
            return true;
        }

        public boolean contains(@Nullable AbstractJClass abstractJClass) {
            AbstractJClass abstractJClass2 = this._getClassForImport(abstractJClass);
            return this.m_aClasses.contains(abstractJClass2);
        }

        public void clear() {
            this.m_aClasses.clear();
            this.m_aNames.clear();
        }

        @Nonnull
        public List<AbstractJClass> getAllSorted() {
            ArrayList<AbstractJClass> arrayList = new ArrayList<AbstractJClass>(this.m_aClasses);
            Collections.sort(arrayList, ClassNameComparator.getInstance());
            return arrayList;
        }
    }

    private static enum EMode {
        COLLECTING,
        PRINTING,
        FIND_ERROR_TYPES;

    }

    private final class NameUsage {
        private final String m_sName;
        private final List<AbstractJClass> m_aReferencedClasses = new ArrayList<AbstractJClass>();
        private boolean m_bIsVariableName;

        public NameUsage(String string) {
            this.m_sName = string;
        }

        public boolean isAmbiguousIn(@Nonnull JDefinedClass jDefinedClass) {
            if (this.m_aReferencedClasses.size() > 1) {
                return true;
            }
            if (this.m_bIsVariableName && !this.m_aReferencedClasses.isEmpty()) {
                return true;
            }
            if (this.m_aReferencedClasses.isEmpty()) {
                return false;
            }
            AbstractJClass abstractJClass = this.m_aReferencedClasses.get(0);
            if (abstractJClass instanceof JAnonymousClass) {
                abstractJClass = ((JAnonymousClass)abstractJClass).base();
            }
            if (abstractJClass._package() == JFormatter.this.m_aPckJavaLang) {
                for (JDefinedClass jDefinedClass2 : jDefinedClass._package().classes()) {
                    if (!jDefinedClass2.name().equals(abstractJClass.name())) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean addReferencedType(@Nonnull AbstractJClass abstractJClass) {
            if (this.m_aReferencedClasses.contains(abstractJClass)) {
                return false;
            }
            return this.m_aReferencedClasses.add(abstractJClass);
        }

        public boolean containsReferencedType(@Nullable AbstractJClass abstractJClass) {
            return this.m_aReferencedClasses.contains(abstractJClass);
        }

        @Nonnull
        public AbstractJClass getSingleReferencedType() {
            assert (this.m_aReferencedClasses.size() == 1);
            return this.m_aReferencedClasses.get(0);
        }

        @Nonnull
        public List<AbstractJClass> getReferencedTypes() {
            return this.m_aReferencedClasses;
        }

        public void setVariableName() {
            for (AbstractJClass abstractJClass : this.m_aReferencedClasses) {
                if (abstractJClass.outer() == null) continue;
                this.m_bIsVariableName = false;
                return;
            }
            this.m_bIsVariableName = true;
        }

        public boolean isVariableName() {
            return this.m_bIsVariableName;
        }

        public boolean isTypeName() {
            return !this.m_aReferencedClasses.isEmpty();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Usages[").append(this.m_sName).append("]");
            stringBuilder.append("; isVarName=").append(this.m_bIsVariableName);
            stringBuilder.append("; refedClasses=").append(this.m_aReferencedClasses);
            return stringBuilder.toString();
        }
    }
}

