/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.writer;

import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.writer.AbstractCodeWriter;
import com.helger.jcodemodel.writer.JCMWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OutputStreamCodeWriter
extends AbstractCodeWriter {
    private final PrintStream m_aPS;

    public OutputStreamCodeWriter(@Nonnull OutputStream outputStream, @Nullable Charset charset) {
        this(outputStream, charset, JCMWriter.getDefaultNewLine());
    }

    public OutputStreamCodeWriter(@Nonnull OutputStream outputStream, @Nullable Charset charset, @Nonnull String string) {
        super(charset, string);
        try {
            this.m_aPS = charset == null ? new PrintStream(outputStream, false) : new PrintStream(outputStream, false, charset.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException);
        }
    }

    @Override
    public OutputStream openBinary(@Nonnull JPackage jPackage, @Nonnull String string) throws IOException {
        return new FilterOutputStream(this.m_aPS){

            @Override
            public void close() {
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.m_aPS.close();
    }
}

