/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.writer;

import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.SourcePrintWriter;
import com.helger.jcodemodel.util.JCValueEnforcer;
import com.helger.jcodemodel.writer.AbstractCodeWriter;
import com.helger.jcodemodel.writer.FilterCodeWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class ProgressCodeWriter
extends FilterCodeWriter {
    private final IProgressTracker m_aPT;

    public ProgressCodeWriter(@Nonnull AbstractCodeWriter abstractCodeWriter, @Nonnull IProgressTracker iProgressTracker) {
        super(abstractCodeWriter);
        JCValueEnforcer.notNull(iProgressTracker, "Progress");
        this.m_aPT = iProgressTracker;
    }

    protected void report(@Nonnull JPackage jPackage, @Nonnull String string) {
        if (jPackage.isUnnamed()) {
            this.m_aPT.println(string);
        } else {
            this.m_aPT.println(jPackage.name().replace('.', File.separatorChar) + File.separatorChar + string);
        }
    }

    @Override
    public OutputStream openBinary(@Nonnull JPackage jPackage, @Nonnull String string) throws IOException {
        this.report(jPackage, string);
        return super.openBinary(jPackage, string);
    }

    @Override
    public SourcePrintWriter openSource(@Nonnull JPackage jPackage, @Nonnull String string) throws IOException {
        this.report(jPackage, string);
        return super.openSource(jPackage, string);
    }

    @FunctionalInterface
    public static interface IProgressTracker
    extends Serializable {
        public void println(@Nonnull String var1);
    }
}

