/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;

public class JArrayCompRef
implements IJAssignmentTarget {
    private final IJExpression m_aArray;
    private final IJExpression m_aIndex;

    protected JArrayCompRef(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        JCValueEnforcer.notNull(iJExpression, "Array");
        JCValueEnforcer.notNull(iJExpression2, "Index");
        this.m_aArray = iJExpression;
        this.m_aIndex = iJExpression2;
    }

    @Nonnull
    public IJExpression array() {
        return this.m_aArray;
    }

    @Nonnull
    public IJExpression index() {
        return this.m_aIndex;
    }

    @Override
    public void generate(@Nonnull IJFormatter iJFormatter) {
        iJFormatter.generable(this.m_aArray).print('[').generable(this.m_aIndex).print(']');
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JArrayCompRef jArrayCompRef = (JArrayCompRef)object;
        return JCEqualsHelper.isEqual(this.m_aArray, jArrayCompRef.m_aArray) && JCEqualsHelper.isEqual(this.m_aIndex, jArrayCompRef.m_aIndex);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this.m_aArray, this.m_aIndex);
    }
}

