/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JEnumConstant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JCase
implements IJStatement {
    private final IJExpression m_aLabelExpr;
    private boolean m_bIsDefaultCase = false;
    private JBlock m_aBody;

    public JCase(@Nonnull IJExpression iJExpression) {
        this(iJExpression, false);
    }

    public JCase(@Nullable IJExpression iJExpression, boolean bl) {
        this.m_aLabelExpr = iJExpression;
        this.m_bIsDefaultCase = bl;
    }

    @Nullable
    public IJExpression label() {
        return this.m_aLabelExpr;
    }

    public boolean isDefaultCase() {
        return this.m_bIsDefaultCase;
    }

    @Nonnull
    public JBlock body() {
        if (this.m_aBody == null) {
            this.m_aBody = new JBlock();
        }
        return this.m_aBody;
    }

    @Override
    public void state(@Nonnull IJFormatter iJFormatter2) {
        iJFormatter2.indent();
        if (this.m_bIsDefaultCase) {
            iJFormatter2.print("default:").newline();
        } else {
            IJExpression iJExpression = this.m_aLabelExpr instanceof JEnumConstant ? iJFormatter -> iJFormatter.print(((JEnumConstant)this.m_aLabelExpr).name()) : this.m_aLabelExpr;
            iJFormatter2.print("case ").generable(iJExpression).print(':').newline();
        }
        if (this.m_aBody != null) {
            iJFormatter2.statement(this.m_aBody);
        }
        iJFormatter2.outdent();
    }
}

