/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJDocCommentable;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JDocComment;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JMods;
import com.helger.jcodemodel.JVar;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JFieldVar
extends JVar
implements IJDocCommentable {
    private final JDefinedClass m_aOwnerClass;
    private JDocComment m_aJavaDoc;

    protected JFieldVar(@Nonnull JDefinedClass jDefinedClass, @Nonnull JMods jMods, @Nonnull AbstractJType abstractJType, @Nonnull String string, @Nullable IJExpression iJExpression) {
        super(jMods, abstractJType, string, iJExpression);
        this.m_aOwnerClass = JCValueEnforcer.notNull(jDefinedClass, "OwnerClass");
    }

    @Nonnull
    public JDefinedClass owner() {
        return this.m_aOwnerClass;
    }

    @Override
    public void name(@Nonnull String string) {
        JCValueEnforcer.isFalse(this.m_aOwnerClass.containsField(string), () -> "Field name '" + string + "' is already in use");
        String string2 = this.name();
        super.name(string);
        this.m_aOwnerClass.internalRenameField(string2, string, this);
    }

    @Override
    @Nonnull
    public JDocComment javadoc() {
        if (this.m_aJavaDoc == null) {
            this.m_aJavaDoc = new JDocComment(this.m_aOwnerClass.owner());
        }
        return this.m_aJavaDoc;
    }

    @Nonnull
    public JFieldRef fieldRef() {
        return new JFieldRef((AbstractJType)this.m_aOwnerClass, (JVar)this);
    }

    @Override
    public void declare(@Nonnull IJFormatter iJFormatter) {
        if (this.m_aJavaDoc != null) {
            iJFormatter.generable(this.m_aJavaDoc);
        }
        super.declare(iJFormatter);
    }

    @Override
    public void generate(@Nonnull IJFormatter iJFormatter) {
        super.generate(iJFormatter);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JFieldVar jFieldVar = (JFieldVar)object;
        return JCEqualsHelper.isEqual(this.m_aOwnerClass, jFieldVar.m_aOwnerClass);
    }

    @Override
    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(super.hashCode(), new Object[]{this.m_aOwnerClass});
    }
}

