/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.ChangeInV4;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JLambdaMethodRef
implements IJExpression {
    private final boolean m_bStatic;
    private final AbstractJType m_aType;
    private final JVar m_aVar;
    private final IJExpression m_aLhsExpr;
    private final JMethod m_aMethod;
    private final String m_sMethodName;

    public JLambdaMethodRef(@Nonnull JMethod jMethod) {
        JCValueEnforcer.notNull(jMethod, "Method");
        JCValueEnforcer.isTrue(jMethod.mods().isStatic(), "Only static methods can be used with this constructor. Use the constructor with JVar for instance methods.");
        this.m_bStatic = true;
        this.m_aType = jMethod.owningClass();
        this.m_aVar = null;
        this.m_aLhsExpr = null;
        this.m_aMethod = jMethod;
        this.m_sMethodName = null;
    }

    @Deprecated
    @ChangeInV4
    public JLambdaMethodRef(@Nonnull AbstractJType abstractJType) {
        this(abstractJType, "new");
    }

    public JLambdaMethodRef(@Nonnull AbstractJType abstractJType, @Nonnull String string) {
        JCValueEnforcer.notNull(abstractJType, "Type");
        JCValueEnforcer.notEmpty(string, "Method");
        this.m_bStatic = true;
        this.m_aType = abstractJType;
        this.m_aVar = null;
        this.m_aLhsExpr = null;
        this.m_aMethod = null;
        this.m_sMethodName = string;
    }

    public JLambdaMethodRef(@Nonnull JVar jVar, @Nonnull String string) {
        JCValueEnforcer.notNull(jVar, "Var");
        JCValueEnforcer.notEmpty(string, "Method");
        this.m_bStatic = false;
        this.m_aType = jVar.type();
        this.m_aVar = jVar;
        this.m_aLhsExpr = null;
        this.m_aMethod = null;
        this.m_sMethodName = string;
    }

    public JLambdaMethodRef(@Nonnull JVar jVar, @Nonnull JMethod jMethod) {
        JCValueEnforcer.notNull(jVar, "Var");
        JCValueEnforcer.notNull(jMethod, "Method");
        JCValueEnforcer.isFalse(jMethod.mods().isStatic(), "Only instance methods can be used with this constructor. Use the constructor with JMethod only for static methods.");
        this.m_bStatic = false;
        this.m_aType = jVar.type();
        this.m_aVar = jVar;
        this.m_aLhsExpr = null;
        this.m_aMethod = jMethod;
        this.m_sMethodName = null;
    }

    public JLambdaMethodRef(@Nonnull IJExpression iJExpression, @Nonnull String string) {
        JCValueEnforcer.notNull(iJExpression, "Invocation");
        JCValueEnforcer.notEmpty(string, "Method");
        this.m_bStatic = false;
        this.m_aType = null;
        this.m_aVar = null;
        this.m_aLhsExpr = iJExpression;
        this.m_aMethod = null;
        this.m_sMethodName = string;
    }

    public JLambdaMethodRef(@Nonnull IJExpression iJExpression, @Nonnull JMethod jMethod) {
        JCValueEnforcer.notNull(iJExpression, "Invocation");
        JCValueEnforcer.notNull(jMethod, "Method");
        JCValueEnforcer.isFalse(jMethod.mods().isStatic(), "Only instance methods can be used with this constructor. Use the constructor with JMethod only for static methods.");
        this.m_bStatic = false;
        this.m_aType = jMethod.owningClass();
        this.m_aVar = null;
        this.m_aLhsExpr = iJExpression;
        this.m_aMethod = jMethod;
        this.m_sMethodName = null;
    }

    public boolean isStaticRef() {
        return this.m_bStatic;
    }

    @Nullable
    public AbstractJType type() {
        return this.m_aType;
    }

    @Nullable
    public JVar var() {
        return this.m_aVar;
    }

    @Deprecated
    @Nullable
    @ChangeInV4
    public JInvocation invocation() {
        return this.m_aLhsExpr instanceof JInvocation ? (JInvocation)this.m_aLhsExpr : null;
    }

    @Nullable
    public IJExpression lhsExpr() {
        return this.m_aLhsExpr;
    }

    @Nullable
    public JMethod method() {
        return this.m_aMethod;
    }

    @Nonnull
    public String methodName() {
        return this.m_aMethod != null ? this.m_aMethod.name() : this.m_sMethodName;
    }

    @Override
    public void generate(@Nonnull IJFormatter iJFormatter) {
        if (this.isStaticRef()) {
            iJFormatter.type(this.type());
        } else if (this.m_aVar != null) {
            iJFormatter.generable(this.m_aVar);
        } else {
            iJFormatter.generable(this.m_aLhsExpr);
        }
        iJFormatter.print("::").print(this.methodName());
    }

    @Nonnull
    public static JLambdaMethodRef createForNew(@Nonnull AbstractJType abstractJType) {
        return new JLambdaMethodRef(abstractJType, "new");
    }
}

