/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;

public class JOpTernary
implements IJExpression {
    private final IJExpression m_aExpr1;
    private final String m_sOperator1;
    private final IJExpression m_aExpr2;
    private final String m_sOperator2;
    private final IJExpression m_aExpr3;

    protected JOpTernary(@Nonnull IJExpression iJExpression, @Nonnull String string, @Nonnull IJExpression iJExpression2, @Nonnull String string2, @Nonnull IJExpression iJExpression3) {
        this.m_aExpr1 = JCValueEnforcer.notNull(iJExpression, "Expr1");
        this.m_sOperator1 = JCValueEnforcer.notNull(string, "Operator1");
        this.m_aExpr2 = JCValueEnforcer.notNull(iJExpression2, "Expr2");
        this.m_sOperator2 = JCValueEnforcer.notNull(string2, "Operator2");
        this.m_aExpr3 = JCValueEnforcer.notNull(iJExpression3, "Expr3");
    }

    @Nonnull
    public IJExpression expr1() {
        return this.m_aExpr1;
    }

    @Nonnull
    public String op1() {
        return this.m_sOperator1;
    }

    @Nonnull
    public IJGenerable expr2() {
        return this.m_aExpr2;
    }

    @Nonnull
    public String op2() {
        return this.m_sOperator2;
    }

    @Nonnull
    public IJGenerable expr3() {
        return this.m_aExpr3;
    }

    @Override
    public void generate(@Nonnull IJFormatter iJFormatter) {
        iJFormatter.print('(').generable(this.m_aExpr1).print(this.m_sOperator1).generable(this.m_aExpr2).print(this.m_sOperator2).generable(this.m_aExpr3).print(')');
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JOpTernary jOpTernary = (JOpTernary)object;
        return JCEqualsHelper.isEqual(this.m_aExpr1, jOpTernary.m_aExpr1) && JCEqualsHelper.isEqual(this.m_sOperator1, jOpTernary.m_sOperator1) && JCEqualsHelper.isEqual(this.m_aExpr2, jOpTernary.m_aExpr2) && JCEqualsHelper.isEqual(this.m_sOperator2, jOpTernary.m_sOperator2) && JCEqualsHelper.isEqual(this.m_aExpr3, jOpTernary.m_aExpr3);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this.m_aExpr1, this.m_sOperator1, this.m_aExpr2, this.m_sOperator2, this.m_aExpr3);
    }
}

