/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.ChangeInV4;
import com.helger.jcodemodel.EClassType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJClassContainer;
import com.helger.jcodemodel.IJDeclaration;
import com.helger.jcodemodel.IJDocCommentable;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JCodeModelException;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JDocComment;
import com.helger.jcodemodel.JJavaName;
import com.helger.jcodemodel.JResourceAlreadyExistsException;
import com.helger.jcodemodel.JResourceDir;
import com.helger.jcodemodel.fmt.AbstractJResourceFile;
import com.helger.jcodemodel.util.FSName;
import com.helger.jcodemodel.util.JCStringHelper;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JPackage
implements IJDeclaration,
IJGenerable,
IJClassContainer<JDefinedClass>,
IJAnnotatable,
IJDocCommentable {
    public static final char SEPARATOR = '.';
    public static final Pattern VALID_PACKAGE_NAME_ANYCASE = Pattern.compile("[A-Za-z_][A-Za-z0-9_]*");
    public static final Pattern VALID_PACKAGE_NAME_LOWERCASE = Pattern.compile("[a-z_][a-z0-9_]*");
    private static final AtomicBoolean FORCE_PACKAGE_NAME_LOWERCASE = new AtomicBoolean(false);
    private final String m_sName;
    private final JCodeModel m_aOwner;
    private final Map<FSName, JDefinedClass> m_aClasses = new TreeMap<FSName, JDefinedClass>();
    @ChangeInV4
    private final Set<AbstractJResourceFile> m_aResources = new HashSet<AbstractJResourceFile>();
    private List<JAnnotationUse> m_aAnnotations;
    private JDocComment m_aJavaDoc;

    public static boolean isForcePackageNameLowercase() {
        return FORCE_PACKAGE_NAME_LOWERCASE.get();
    }

    public static void setForcePackageNameLowercase(boolean bl) {
        FORCE_PACKAGE_NAME_LOWERCASE.set(bl);
    }

    public static boolean isForbiddenPackageNamePart(@Nonnull String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        if (JJavaName.isJavaReservedKeyword(string)) {
            return true;
        }
        return JPackage.isForcePackageNameLowercase() ? !VALID_PACKAGE_NAME_LOWERCASE.matcher(string).matches() : !VALID_PACKAGE_NAME_ANYCASE.matcher(string).matches();
    }

    protected JPackage(@Nonnull String string, @Nonnull JCodeModel jCodeModel) {
        JCValueEnforcer.notNull(string, "Name");
        JCValueEnforcer.notNull(jCodeModel, "CodeModel");
        if (string.length() > 0) {
            String[] stringArray;
            for (String string2 : stringArray = JCStringHelper.getExplodedArray('.', string)) {
                if (!JPackage.isForbiddenPackageNamePart(string2)) continue;
                throw new IllegalArgumentException("Part '" + string2 + "' of the package name '" + string + "' is invalid");
            }
        }
        this.m_aOwner = jCodeModel;
        this.m_sName = string;
    }

    @Override
    @Nullable
    public IJClassContainer<?> parentContainer() {
        return this.parent();
    }

    @Nullable
    public JPackage parent() {
        if (this.isUnnamed()) {
            return null;
        }
        int n = this.m_sName.lastIndexOf(46);
        if (n < 0) {
            return this.m_aOwner.rootPackage();
        }
        return this.m_aOwner._package(this.m_sName.substring(0, n));
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isPackage() {
        return true;
    }

    @Override
    @Nonnull
    public JPackage getPackage() {
        return this;
    }

    @Nonnull
    private FSName _createFSName(@Nonnull String string) {
        if (this.m_aOwner.getFileSystemConvention().isCaseSensistive()) {
            return FSName.createCaseSensitive(string);
        }
        return FSName.createCaseInsensitive(string);
    }

    @Override
    @Nonnull
    public JDefinedClass _class(int n, @Nonnull String string, @Nonnull EClassType eClassType) throws JCodeModelException {
        String string2;
        FSName fSName = this._createFSName(string);
        JDefinedClass jDefinedClass = this.m_aClasses.get(fSName);
        if (jDefinedClass != null) {
            throw new JClassAlreadyExistsException(jDefinedClass);
        }
        String string3 = this.m_sName.replace('.', '/');
        JResourceDir jResourceDir = this.m_aOwner.resourceDir(string3);
        if (jResourceDir.hasResourceFile(string2 = string + ".java")) {
            throw new JResourceAlreadyExistsException(jResourceDir.fullChildName(string2));
        }
        if (this.m_aOwner.containsResourceDir(jResourceDir.fullChildName(string2))) {
            throw new JResourceAlreadyExistsException(jResourceDir.fullChildName(string2));
        }
        jDefinedClass = new JDefinedClass(this, n, string, eClassType);
        this.m_aClasses.put(fSName, jDefinedClass);
        return jDefinedClass;
    }

    @Nullable
    public JDefinedClass _getClass(@Nullable String string) {
        FSName fSName = this._createFSName(string);
        return this.m_aClasses.get(fSName);
    }

    @Nonnull
    @Deprecated
    @ChangeInV4
    public AbstractJResourceFile addResourceFile(@Nonnull AbstractJResourceFile abstractJResourceFile) {
        JCValueEnforcer.notNull(abstractJResourceFile, "ResourceFile");
        this.m_aResources.add(abstractJResourceFile);
        return abstractJResourceFile;
    }

    @Deprecated
    @ChangeInV4
    public boolean hasResourceFile(@Nullable String string) {
        for (AbstractJResourceFile abstractJResourceFile : this.m_aResources) {
            if (!abstractJResourceFile.name().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    @Nonnull
    @ChangeInV4
    public Iterator<AbstractJResourceFile> propertyFiles() {
        return this.resourceFiles();
    }

    @Deprecated
    @Nonnull
    @ChangeInV4
    public Iterator<AbstractJResourceFile> resourceFiles() {
        return this.m_aResources.iterator();
    }

    @Deprecated
    @Nonnull
    @ChangeInV4
    public List<AbstractJResourceFile> getAllResourceFiles() {
        return new ArrayList<AbstractJResourceFile>(this.m_aResources);
    }

    @Override
    @Nonnull
    public JDocComment javadoc() {
        if (this.m_aJavaDoc == null) {
            this.m_aJavaDoc = new JDocComment(this.owner());
        }
        return this.m_aJavaDoc;
    }

    @Nullable
    public JDocComment javadocOrNull() {
        return this.m_aJavaDoc;
    }

    public void remove(@Nonnull AbstractJClass abstractJClass) {
        JCValueEnforcer.isTrue(abstractJClass._package() == this, () -> "the specified class (" + abstractJClass.fullName() + ") is not a member of this package (" + this.name() + "), or it is a referenced class");
        FSName fSName = this._createFSName(abstractJClass.name());
        this.m_aClasses.remove(fSName);
    }

    @Nonnull
    public AbstractJClass ref(@Nonnull String string) throws ClassNotFoundException {
        JCValueEnforcer.isTrue(string.indexOf(46) < 0, () -> "JClass name contains '.': " + string);
        String string2 = this.isUnnamed() ? string : this.m_sName + '.' + string;
        return this.m_aOwner.ref(Class.forName(string2));
    }

    @Nonnull
    public JPackage subPackage(@Nonnull String string) {
        return this.owner()._package(this.isUnnamed() ? string : this.m_sName + '.' + string);
    }

    @Override
    @Nonnull
    public Collection<JDefinedClass> classes() {
        return this.m_aClasses.values();
    }

    public boolean isDefined(@Nullable String string) {
        if (string != null) {
            for (JDefinedClass jDefinedClass : this.m_aClasses.values()) {
                if (!jDefinedClass.name().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isUnnamed() {
        return this.m_sName.length() == 0;
    }

    @Nonnull
    public String name() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public final JCodeModel owner() {
        return this.m_aOwner;
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull AbstractJClass abstractJClass) {
        JCValueEnforcer.isFalse(this.isUnnamed(), "the root package cannot be annotated");
        if (this.m_aAnnotations == null) {
            this.m_aAnnotations = new ArrayList<JAnnotationUse>();
        }
        JAnnotationUse jAnnotationUse = new JAnnotationUse(abstractJClass);
        this.m_aAnnotations.add(jAnnotationUse);
        return jAnnotationUse;
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull Class<? extends Annotation> clazz) {
        return this.annotate(this.m_aOwner.ref(clazz));
    }

    @Nonnull
    public List<JAnnotationUse> annotationsMutable() {
        if (this.m_aAnnotations == null) {
            this.m_aAnnotations = new ArrayList<JAnnotationUse>();
        }
        return this.m_aAnnotations;
    }

    @Override
    @Nonnull
    public Collection<JAnnotationUse> annotations() {
        return Collections.unmodifiableList(this.annotationsMutable());
    }

    @Nonnull
    File toPath(@Nonnull File file) {
        if (this.isUnnamed()) {
            return file;
        }
        return new File(file, this.m_sName.replace('.', File.separatorChar));
    }

    @Override
    public void declare(@Nonnull IJFormatter iJFormatter) {
        if (!this.isUnnamed()) {
            iJFormatter.print("package").print(this.m_sName).print(';').newline();
        }
    }

    @Override
    public void generate(@Nonnull IJFormatter iJFormatter) {
        iJFormatter.print(this.m_sName);
    }

    boolean buildsErrorTypeRefs() {
        for (JDefinedClass jDefinedClass : this.m_aClasses.values()) {
            if (jDefinedClass.isHidden() || !jDefinedClass.containsErrorTypes()) continue;
            return true;
        }
        return false;
    }

    int countArtifacts() {
        int n = 0;
        for (JDefinedClass jDefinedClass : this.m_aClasses.values()) {
            if (jDefinedClass.isHidden()) continue;
            ++n;
        }
        if (this.m_aAnnotations != null || this.m_aJavaDoc != null) {
            ++n;
        }
        return n += this.m_aResources.size();
    }
}

