/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.JArrayClass;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;

public class JPrimitiveType
extends AbstractJType {
    private final JCodeModel m_aOwner;
    private final String m_sTypeName;
    private final AbstractJClass m_aWrapperClass;
    private JArrayClass m_aArrayClass;
    private boolean m_bUseValueOf;

    protected JPrimitiveType(@Nonnull JCodeModel jCodeModel, @Nonnull String string, @Nonnull Class<?> clazz, boolean bl) {
        JCValueEnforcer.notNull(jCodeModel, "Owner");
        JCValueEnforcer.notNull(string, "TypeName");
        JCValueEnforcer.notNull(clazz, "Wrapper");
        this.m_aOwner = jCodeModel;
        this.m_sTypeName = string;
        this.m_aWrapperClass = jCodeModel.ref(clazz);
        this.m_bUseValueOf = bl;
    }

    @Override
    @Nonnull
    public JCodeModel owner() {
        return this.m_aOwner;
    }

    @Override
    @Nonnull
    public String fullName() {
        return this.m_sTypeName;
    }

    @Override
    @Nonnull
    public String name() {
        return this.fullName();
    }

    @Override
    public final boolean isPrimitive() {
        return true;
    }

    @Override
    @Nonnull
    public JArrayClass array() {
        if (this.m_aArrayClass == null) {
            this.m_aArrayClass = new JArrayClass(this.m_aOwner, this);
        }
        return this.m_aArrayClass;
    }

    @Override
    @Nonnull
    public final AbstractJClass boxify() {
        return this.m_aWrapperClass;
    }

    @Override
    @Deprecated
    @Nonnull
    public final AbstractJType unboxify() {
        return this;
    }

    @Nonnull
    public IJExpression wrap(@Nonnull IJExpression iJExpression) {
        if ("void".equals(this.m_sTypeName)) {
            throw new IllegalStateException("Cannot wrap a 'void' expression!");
        }
        if (this.m_bUseValueOf) {
            return this.boxify().staticInvoke("valueOf").arg(iJExpression);
        }
        return JExpr._new(this.boxify()).arg(iJExpression);
    }

    @Nonnull
    public IJExpression unwrap(@Nonnull IJExpression iJExpression) {
        if ("void".equals(this.m_sTypeName)) {
            throw new IllegalStateException("Cannot unwrap a 'void' expression!");
        }
        return iJExpression.invoke(this.m_sTypeName + "Value");
    }

    public boolean useValueOf() {
        return this.m_bUseValueOf;
    }

    public void useValueOf(boolean bl) {
        this.m_bUseValueOf = bl;
    }

    @Override
    public void generate(@Nonnull IJFormatter iJFormatter) {
        iJFormatter.print(this.m_sTypeName);
    }
}

