/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJOwned;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JCodeModelException;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.JResourceAlreadyExistsException;
import com.helger.jcodemodel.fmt.AbstractJResourceFile;
import com.helger.jcodemodel.util.FSName;
import com.helger.jcodemodel.util.JCStringHelper;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JResourceDir
implements IJOwned {
    public static final char SEPARATOR = '/';
    public static final String SEPARATOR_STR = Character.toString('/');
    private final JCodeModel m_aOwner;
    private final JResourceDir m_aParentDir;
    private final String m_sName;
    private final Map<FSName, AbstractJResourceFile> m_aResources = new TreeMap<FSName, AbstractJResourceFile>();

    protected JResourceDir(@Nonnull JCodeModel jCodeModel, @Nullable JResourceDir jResourceDir, @Nonnull String string) {
        JCValueEnforcer.notNull(string, "Name");
        JCValueEnforcer.notNull(jCodeModel, "CodeModel");
        if (jResourceDir == null) {
            JCValueEnforcer.isTrue(string.length() == 0, "If no parent directory is provided, the name must be empty");
        }
        if (string.length() == 0) {
            JCValueEnforcer.isNull((Object)jResourceDir, "If no name is provided, the parent directory must be null");
        }
        this.m_aOwner = jCodeModel;
        this.m_aParentDir = jResourceDir;
        this.m_sName = string;
        if (string.length() > 0) {
            for (String string2 : JCStringHelper.getExplodedArray('/', string)) {
                if (jCodeModel.getFileSystemConvention().isValidDirectoryName(string2)) continue;
                throw new IllegalArgumentException("Resource directory name '" + string + "' contains the the invalid part '" + string2 + "' according to the current file system conventions");
            }
        }
    }

    @Override
    @Nonnull
    public final JCodeModel owner() {
        return this.m_aOwner;
    }

    @Nonnull
    public final String name() {
        return this.m_sName;
    }

    @Nullable
    public JResourceDir parent() {
        return this.m_aParentDir;
    }

    @Nonnull
    private FSName _createFSName(@Nonnull String string) {
        if (this.m_aOwner.getFileSystemConvention().isCaseSensistive()) {
            return FSName.createCaseSensitive(string);
        }
        return FSName.createCaseInsensitive(string);
    }

    @Nonnull
    private JPackage _getMatchingPackage() {
        return this.owner()._package(this.m_sName.replace('/', '.'));
    }

    @Nonnull
    public <T extends AbstractJResourceFile> T addResourceFile(@Nonnull T t) throws JCodeModelException {
        JDefinedClass jDefinedClass;
        JCValueEnforcer.notNull(t, "ResourceFile");
        String string = t.name();
        if (!this.m_aOwner.getFileSystemConvention().isValidFilename(string)) {
            throw new IllegalArgumentException("Resource filename '" + string + "' is invalid according to the current file system conventions");
        }
        if (this.m_aOwner.containsResourceDir(this.fullChildName(string))) {
            throw new JResourceAlreadyExistsException(this.fullChildName(string));
        }
        FSName fSName = this._createFSName(string);
        if (this.m_aResources.containsKey(fSName)) {
            throw new JResourceAlreadyExistsException(this.fullChildName(string));
        }
        if (JCStringHelper.endsWithCaseInsensitive(string, ".java") && (jDefinedClass = this._getMatchingPackage()._getClass(string.substring(0, string.length() - 5))) != null) {
            throw new JClassAlreadyExistsException(jDefinedClass);
        }
        this.m_aResources.put(fSName, t);
        return t;
    }

    public boolean hasResourceFile(@Nullable String string) {
        FSName fSName = this._createFSName(string);
        return this.m_aResources.containsKey(fSName);
    }

    @Nonnull
    public Iterator<AbstractJResourceFile> resourceFiles() {
        return this.m_aResources.values().iterator();
    }

    @Nonnull
    public List<AbstractJResourceFile> getAllResourceFiles() {
        return new ArrayList<AbstractJResourceFile>(this.m_aResources.values());
    }

    @Nonnull
    public JResourceDir subDir(@Nonnull String string) throws JCodeModelException {
        JDefinedClass jDefinedClass;
        if (this.hasResourceFile(string)) {
            throw new JResourceAlreadyExistsException(this.fullChildName(string));
        }
        if (JCStringHelper.endsWithCaseInsensitive(string, ".java") && (jDefinedClass = this._getMatchingPackage()._getClass(string.substring(0, string.length() - 5))) != null) {
            throw new JClassAlreadyExistsException(jDefinedClass);
        }
        return this.owner().resourceDir(this.isUnnamed() ? string : this.m_sName + '/' + string);
    }

    public final boolean isUnnamed() {
        return this.m_sName.length() == 0;
    }

    @Nonnull
    File toPath(@Nonnull File file) {
        return this.isUnnamed() ? file : new File(file, this.m_sName);
    }

    @Nonnegative
    int countArtifacts() {
        return this.m_aResources.size();
    }

    @Nonnull
    String fullChildName(@Nonnull String string) {
        return this.isUnnamed() ? string : this.m_sName + '/' + string;
    }

    @Nonnull
    static JResourceDir root(@Nonnull JCodeModel jCodeModel) {
        return new JResourceDir(jCodeModel, null, "");
    }
}

