/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;

public class JSingleLineCommentStatement
implements IJStatement {
    private String m_sComment;

    public JSingleLineCommentStatement(@Nonnull String string) {
        this.comment(string);
    }

    @Nonnull
    public String comment() {
        return this.m_sComment;
    }

    public final void comment(@Nonnull String string) {
        JCValueEnforcer.notNull(string, "Comment");
        this.m_sComment = string;
    }

    @Override
    public void state(@Nonnull IJFormatter iJFormatter) {
        if (this.m_sComment.length() > 0) {
            iJFormatter.print("// ").print(this.m_sComment).newline();
        } else {
            iJFormatter.print("//").newline();
        }
    }
}

