/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCatchBlock;
import com.helger.jcodemodel.JTryResource;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class JTryBlock
implements IJStatement {
    private final List<JTryResource> m_aResources = new ArrayList<JTryResource>();
    private final JBlock m_aBody = new JBlock();
    private final List<JCatchBlock> m_aCatches = new ArrayList<JCatchBlock>();
    private JBlock m_aFinally;

    @Nonnull
    public List<JTryResource> tryResources() {
        return this.m_aResources;
    }

    @Nonnull
    public JBlock body() {
        return this.m_aBody;
    }

    @Nonnull
    public JCatchBlock _catch(@Nonnull AbstractJClass abstractJClass) {
        JCatchBlock jCatchBlock = new JCatchBlock(abstractJClass);
        this.m_aCatches.add(jCatchBlock);
        return jCatchBlock;
    }

    @Nonnull
    public List<JCatchBlock> catches() {
        return this.m_aCatches;
    }

    public boolean hasCatchBlock() {
        return !this.m_aCatches.isEmpty();
    }

    @Nonnull
    public JBlock _finally() {
        if (this.m_aFinally == null) {
            this.m_aFinally = new JBlock();
        }
        return this.m_aFinally;
    }

    public void resetFinally() {
        this.m_aFinally = null;
    }

    public boolean hasFinally() {
        return this.m_aFinally != null;
    }

    @Override
    public void state(@Nonnull IJFormatter iJFormatter) {
        iJFormatter.print("try");
        if (!this.m_aResources.isEmpty()) {
            iJFormatter.print('(');
            boolean bl = true;
            for (JTryResource jTryResource : this.m_aResources) {
                if (bl) {
                    bl = false;
                } else {
                    iJFormatter.print(';').newline();
                }
                iJFormatter.generable(jTryResource);
            }
            iJFormatter.print(')');
        }
        iJFormatter.generable(this.m_aBody);
        for (JCatchBlock jCatchBlock : this.m_aCatches) {
            iJFormatter.generable(jCatchBlock);
        }
        if (this.m_aFinally != null) {
            iJFormatter.print("finally").generable(this.m_aFinally);
        }
        iJFormatter.newline();
    }
}

