/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JOp;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;

public class JWhileLoop
implements IJStatement {
    private final IJExpression m_aTextExpr;
    private JBlock m_aBody;

    public JWhileLoop(@Nonnull IJExpression iJExpression) {
        JCValueEnforcer.notNull(iJExpression, "TestExpr");
        this.m_aTextExpr = iJExpression;
    }

    @Nonnull
    public IJExpression test() {
        return this.m_aTextExpr;
    }

    @Nonnull
    public JBlock body() {
        if (this.m_aBody == null) {
            this.m_aBody = new JBlock();
        }
        return this.m_aBody;
    }

    @Override
    public void state(@Nonnull IJFormatter iJFormatter) {
        if (JOp.hasTopOp(this.m_aTextExpr)) {
            iJFormatter.print("while ").generable(this.m_aTextExpr);
        } else {
            iJFormatter.print("while (").generable(this.m_aTextExpr).print(')');
        }
        if (this.m_aBody != null) {
            iJFormatter.statement(this.m_aBody);
        } else {
            iJFormatter.print(';').newline();
        }
    }
}

