/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.meta;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JTypeVar;
import com.helger.jcodemodel.JVar;
import com.helger.jcodemodel.meta.Annotator;
import com.helger.jcodemodel.meta.CodeModelBuildingException;
import com.helger.jcodemodel.meta.DecidedErrorTypesModelsAdapter;
import com.helger.jcodemodel.meta.ErrorTypeFound;
import com.helger.jcodemodel.meta.TypeEnvironment;
import java.util.List;
import javax.annotation.Nonnull;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

class ClassFiller {
    private final JDefinedClass m_aNewClass;
    private final JCodeModel m_aCodeModel;
    private final DecidedErrorTypesModelsAdapter m_aModelsAdapter;

    ClassFiller(JCodeModel jCodeModel, DecidedErrorTypesModelsAdapter decidedErrorTypesModelsAdapter, JDefinedClass jDefinedClass) {
        this.m_aCodeModel = jCodeModel;
        this.m_aModelsAdapter = decidedErrorTypesModelsAdapter;
        this.m_aNewClass = jDefinedClass;
    }

    /*
     * WARNING - void declaration
     */
    void fillClass(@Nonnull TypeElement typeElement, @Nonnull TypeEnvironment typeEnvironment) throws CodeModelBuildingException, ErrorTypeFound {
        this.m_aNewClass.hide();
        Annotator annotator = new Annotator(this.m_aModelsAdapter, this.m_aNewClass, typeEnvironment);
        annotator.annotate(typeElement.getAnnotationMirrors());
        for (TypeParameterElement iterator : typeElement.getTypeParameters()) {
            JTypeVar jTypeVar = this.m_aNewClass.generify(iterator.getSimpleName().toString());
            typeEnvironment.put(jTypeVar.name(), jTypeVar);
            for (TypeMirror typeMirror : iterator.getBounds()) {
                jTypeVar.bound((AbstractJClass)this.m_aModelsAdapter.toJType(typeMirror, typeEnvironment));
            }
        }
        TypeMirror typeMirror = typeElement.getSuperclass();
        if (typeMirror != null && typeMirror.getKind() != TypeKind.NONE) {
            this.m_aNewClass._extends((AbstractJClass)this.m_aModelsAdapter.toJType(typeMirror, typeEnvironment));
        }
        for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
            this.m_aNewClass._implements((AbstractJClass)this.m_aModelsAdapter.toJType(typeMirror2, typeEnvironment));
        }
        for (Element element : typeElement.getEnclosedElements()) {
            Object object;
            Object object2;
            if (element.getKind().equals((Object)ElementKind.INTERFACE) || element.getKind().equals((Object)ElementKind.CLASS)) {
                object2 = (TypeElement)element;
                this.m_aModelsAdapter.defineInnerClass(this.m_aNewClass, (TypeElement)object2, typeEnvironment.enclosed());
                continue;
            }
            if (!element.getKind().equals((Object)ElementKind.METHOD)) continue;
            object2 = (ExecutableElement)element;
            JMethod jMethod = this.m_aNewClass.method(DecidedErrorTypesModelsAdapter.toJMod(object2.getModifiers()), this.m_aCodeModel.VOID, object2.getSimpleName().toString());
            TypeEnvironment typeEnvironment2 = typeEnvironment.enclosed();
            Annotator annotator2 = new Annotator(this.m_aModelsAdapter, jMethod, typeEnvironment);
            annotator2.annotate(object2.getAnnotationMirrors());
            for (TypeParameterElement typeParameterElement : object2.getTypeParameters()) {
                object = jMethod.generify(typeParameterElement.getSimpleName().toString());
                typeEnvironment2.put(((JTypeVar)object).name(), (AbstractJType)object);
                for (TypeMirror typeMirror3 : typeParameterElement.getBounds()) {
                    ((JTypeVar)object).bound((AbstractJClass)this.m_aModelsAdapter.toJType(typeMirror3, typeEnvironment2));
                }
            }
            jMethod.type(this.m_aModelsAdapter.toJType(object2.getReturnType(), typeEnvironment2));
            for (TypeMirror typeMirror4 : object2.getThrownTypes()) {
                object = (AbstractJClass)this.m_aModelsAdapter.toJType(typeMirror4, typeEnvironment2);
                jMethod._throws((AbstractJClass)object);
            }
            List<? extends VariableElement> list = object2.getParameters();
            boolean bl = false;
            object = list.iterator();
            while (object.hasNext()) {
                void var12_20;
                VariableElement variableElement = (VariableElement)object.next();
                String string = variableElement.getSimpleName().toString();
                TypeMirror typeMirror5 = variableElement.asType();
                AbstractJType abstractJType = this.m_aModelsAdapter.toJType(typeMirror5, typeEnvironment2);
                JVar jVar = object2.isVarArgs() && var12_20 == list.size() - 1 ? jMethod.varParam(DecidedErrorTypesModelsAdapter.toJMod(variableElement.getModifiers()), abstractJType.elementType(), string) : jMethod.param(DecidedErrorTypesModelsAdapter.toJMod(variableElement.getModifiers()), abstractJType, string);
                Annotator annotator3 = new Annotator(this.m_aModelsAdapter, jVar, typeEnvironment2);
                annotator3.annotate(variableElement.getAnnotationMirrors());
                ++var12_20;
            }
        }
    }
}

