/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.util;

import com.helger.jcodemodel.util.IFileSystemConvention;
import com.helger.jcodemodel.util.JCFilenameHelper;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EFileSystemConvention implements IFileSystemConvention
{
    LINUX(true, JCFilenameHelper::isValidLinuxFilename, JCFilenameHelper::isValidLinuxFilename),
    WINDOWS(false, JCFilenameHelper::isValidWindowsFilename, JCFilenameHelper::isValidWindowsFilename);

    public static final EFileSystemConvention DEFAULT;
    private final boolean m_bIsCaseSensitive;
    private final Predicate<String> m_aDirNameCheck;
    private final Predicate<String> m_aFilenameCheck;

    private EFileSystemConvention(@Nonnull boolean bl, Predicate<String> predicate, Predicate<String> predicate2) {
        this.m_bIsCaseSensitive = bl;
        this.m_aDirNameCheck = predicate;
        this.m_aFilenameCheck = predicate2;
    }

    @Override
    public boolean isCaseSensistive() {
        return this.m_bIsCaseSensitive;
    }

    @Override
    public boolean isValidDirectoryName(@Nullable String string) {
        return this.m_aDirNameCheck.test(string);
    }

    @Override
    public boolean isValidFilename(@Nullable String string) {
        return this.m_aFilenameCheck.test(string);
    }

    static {
        DEFAULT = JCFilenameHelper.isFileSystemCaseSensitive() ? LINUX : WINDOWS;
    }
}

