/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.util;

import com.helger.jcodemodel.util.JCHashCodeGenerator;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.util.Locale;
import javax.annotation.Nonnull;

public final class FSName
implements Comparable<FSName> {
    private final String m_sName;
    private final String m_sKey;
    private int m_nHashCode = 0;

    private FSName(@Nonnull String string, @Nonnull String string2) {
        this.m_sName = string;
        this.m_sKey = string2;
    }

    @Nonnull
    public String getName() {
        return this.m_sName;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FSName fSName = (FSName)object;
        return this.m_sKey.equals(fSName.m_sKey);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new JCHashCodeGenerator(this).append(this.m_sKey).getHashCode();
        }
        return n;
    }

    @Override
    public int compareTo(@Nonnull FSName fSName) {
        return this.m_sKey.compareTo(fSName.m_sKey);
    }

    @Nonnull
    public static FSName createCaseSensitive(@Nonnull String string) {
        JCValueEnforcer.notNull(string, "Name");
        return new FSName(string, string);
    }

    @Nonnull
    public static FSName createCaseInsensitive(@Nonnull String string) {
        JCValueEnforcer.notNull(string, "Name");
        return new FSName(string, string.toUpperCase(Locale.ROOT));
    }
}

