/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.util;

import com.helger.jcodemodel.util.JCEqualsHelper;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public final class JCArrayHelper {
    private JCArrayHelper() {
    }

    @Nonnegative
    public static int getSize(char ... cArray) {
        return cArray == null ? 0 : cArray.length;
    }

    @Nonnegative
    @SafeVarargs
    public static <ELEMENTTYPE> int getSize(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ELEMENTTYPEArray == null ? 0 : ELEMENTTYPEArray.length;
    }

    @SafeVarargs
    public static <ELEMENTTYPE> boolean isNotEmpty(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return JCArrayHelper.getSize(ELEMENTTYPEArray) > 0;
    }

    public static int getFirstIndex(@Nullable char[] cArray, char c) {
        int n = JCArrayHelper.getSize(cArray);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (!JCEqualsHelper.isEqual(cArray[i], c)) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(@Nullable char[] cArray, char c) {
        return JCArrayHelper.getFirstIndex(cArray, c) >= 0;
    }

    public static <ELEMENTTYPE> boolean containsAny(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return JCArrayHelper.isNotEmpty(ELEMENTTYPEArray);
        }
        if (JCArrayHelper.isNotEmpty(ELEMENTTYPEArray)) {
            for (ELEMENTTYPE ELEMENTTYPE : ELEMENTTYPEArray) {
                if (!predicate.test(ELEMENTTYPE)) continue;
                return true;
            }
        }
        return false;
    }
}

