/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JCValueEnforcer {
    private static final AtomicBoolean s_aEnabled = new AtomicBoolean(true);

    private JCValueEnforcer() {
    }

    public static boolean isEnabled() {
        return s_aEnabled.get();
    }

    public static void setEnabled(boolean bl) {
        s_aEnabled.set(bl);
    }

    public static void isTrue(boolean bl, String string) {
        JCValueEnforcer.isTrue(bl, () -> string);
    }

    public static void isTrue(boolean bl, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && !bl) {
            throw new IllegalArgumentException("The expression must be true but it is not: " + supplier.get());
        }
    }

    public static void isFalse(boolean bl, String string) {
        JCValueEnforcer.isFalse(bl, () -> string);
    }

    public static void isFalse(boolean bl, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && bl) {
            throw new IllegalArgumentException("The expression must be false but it is not: " + supplier.get());
        }
    }

    public static <T> void isInstanceOf(@Nullable T t, @Nonnull Class<? extends T> clazz, String string) {
        JCValueEnforcer.isInstanceOf(t, clazz, () -> string);
    }

    public static <T> void isInstanceOf(@Nullable T t, @Nonnull Class<? extends T> clazz, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(clazz, "Class");
        if (JCValueEnforcer.isEnabled() && !clazz.isInstance(t)) {
            throw new IllegalArgumentException(supplier.get() + " must be of class " + clazz.getName() + " but is of type " + t.getClass().getName());
        }
    }

    public static <T> T notNull(T t, String string) {
        if (JCValueEnforcer.isEnabled() && t == null) {
            throw new NullPointerException("The value of '" + string + "' may not be null!");
        }
        return t;
    }

    public static <T> T notNull(T t, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && t == null) {
            throw new NullPointerException("The value of '" + supplier.get() + "' may not be null!");
        }
        return t;
    }

    public static void isNull(Object object, String string) {
        JCValueEnforcer.isNull(object, () -> string);
    }

    public static void isNull(Object object, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && object != null) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be null but is " + object);
        }
    }

    public static <T extends CharSequence> T notEmpty(T t, String string) {
        return JCValueEnforcer.notEmpty(t, () -> string);
    }

    public static <T extends CharSequence> T notEmpty(T t, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(t, supplier);
        if (JCValueEnforcer.isEnabled() && t.length() == 0) {
            throw new IllegalArgumentException("The value of the string '" + supplier.get() + "' may not be empty!");
        }
        return t;
    }

    public static <T> T[] notEmpty(T[] TArray, String string) {
        return JCValueEnforcer.notEmpty(TArray, () -> string);
    }

    public static <T> T[] notEmpty(T[] TArray, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(TArray, supplier);
        if (JCValueEnforcer.isEnabled() && TArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return TArray;
    }

    public static boolean[] notEmpty(boolean[] blArray, String string) {
        return JCValueEnforcer.notEmpty(blArray, () -> string);
    }

    public static boolean[] notEmpty(boolean[] blArray, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(blArray, supplier);
        if (JCValueEnforcer.isEnabled() && blArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return blArray;
    }

    public static byte[] notEmpty(byte[] byArray, String string) {
        return JCValueEnforcer.notEmpty(byArray, () -> string);
    }

    public static byte[] notEmpty(byte[] byArray, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(byArray, supplier);
        if (JCValueEnforcer.isEnabled() && byArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return byArray;
    }

    public static char[] notEmpty(char[] cArray, String string) {
        return JCValueEnforcer.notEmpty(cArray, () -> string);
    }

    public static char[] notEmpty(char[] cArray, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(cArray, supplier);
        if (JCValueEnforcer.isEnabled() && cArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return cArray;
    }

    public static double[] notEmpty(double[] dArray, String string) {
        return JCValueEnforcer.notEmpty(dArray, () -> string);
    }

    public static double[] notEmpty(double[] dArray, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(dArray, supplier);
        if (JCValueEnforcer.isEnabled() && dArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return dArray;
    }

    public static float[] notEmpty(float[] fArray, String string) {
        return JCValueEnforcer.notEmpty(fArray, () -> string);
    }

    public static float[] notEmpty(float[] fArray, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(fArray, supplier);
        if (JCValueEnforcer.isEnabled() && fArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return fArray;
    }

    public static int[] notEmpty(int[] nArray, String string) {
        return JCValueEnforcer.notEmpty(nArray, () -> string);
    }

    public static int[] notEmpty(int[] nArray, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(nArray, supplier);
        if (JCValueEnforcer.isEnabled() && nArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return nArray;
    }

    public static long[] notEmpty(long[] lArray, String string) {
        return JCValueEnforcer.notEmpty(lArray, () -> string);
    }

    public static long[] notEmpty(long[] lArray, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(lArray, supplier);
        if (JCValueEnforcer.isEnabled() && lArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return lArray;
    }

    public static short[] notEmpty(short[] sArray, String string) {
        return JCValueEnforcer.notEmpty(sArray, () -> string);
    }

    public static short[] notEmpty(short[] sArray, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(sArray, supplier);
        if (JCValueEnforcer.isEnabled() && sArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return sArray;
    }

    public static <T extends Collection<?>> T notEmpty(T t, String string) {
        return JCValueEnforcer.notEmpty(t, () -> string);
    }

    public static <T extends Collection<?>> T notEmpty(T t, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(t, supplier);
        if (JCValueEnforcer.isEnabled() && t.isEmpty()) {
            throw new IllegalArgumentException("The value of the collection '" + supplier.get() + "' may not be empty!");
        }
        return t;
    }

    public static <T extends Iterable<?>> T notEmpty(T t, String string) {
        return JCValueEnforcer.notEmpty(t, () -> string);
    }

    public static <T extends Iterable<?>> T notEmpty(T t, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(t, supplier);
        if (JCValueEnforcer.isEnabled() && !t.iterator().hasNext()) {
            throw new IllegalArgumentException("The value of the iterable '" + supplier.get() + "' may not be empty!");
        }
        return t;
    }

    public static <T extends Map<?, ?>> T notEmpty(T t, String string) {
        return JCValueEnforcer.notEmpty(t, () -> string);
    }

    public static <T extends Map<?, ?>> T notEmpty(T t, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(t, supplier);
        if (JCValueEnforcer.isEnabled() && t.isEmpty()) {
            throw new IllegalArgumentException("The value of the map '" + supplier.get() + "' may not be empty!");
        }
        return t;
    }

    @Nullable
    public static <T> T[] noNullValue(T[] TArray, String string) {
        return JCValueEnforcer.noNullValue(TArray, () -> string);
    }

    @Nullable
    public static <T> T[] noNullValue(T[] TArray, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && TArray != null) {
            int n = 0;
            for (T t : TArray) {
                if (t == null) {
                    throw new IllegalArgumentException("Item " + n + " of array '" + supplier.get() + "' may not be null!");
                }
                ++n;
            }
        }
        return TArray;
    }

    @Nullable
    public static <T extends Iterable<?>> T noNullValue(T t, String string) {
        return JCValueEnforcer.noNullValue(t, () -> string);
    }

    @Nullable
    public static <T extends Iterable<?>> T noNullValue(T t, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && t != null) {
            int n = 0;
            for (Object obj : t) {
                if (obj == null) {
                    throw new IllegalArgumentException("Item " + n + " of iterable '" + supplier.get() + "' may not be null!");
                }
                ++n;
            }
        }
        return t;
    }

    @Nullable
    public static <T extends Map<?, ?>> T noNullValue(T t, String string) {
        return JCValueEnforcer.noNullValue(t, () -> string);
    }

    @Nullable
    public static <T extends Map<?, ?>> T noNullValue(T t, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && t != null) {
            for (Map.Entry<?, ?> entry : t.entrySet()) {
                if (entry.getKey() == null) {
                    throw new IllegalArgumentException("A key of map '" + supplier.get() + "' may not be null!");
                }
                if (entry.getValue() != null) continue;
                throw new IllegalArgumentException("A value of map '" + supplier.get() + "' may not be null!");
            }
        }
        return t;
    }

    public static <T> T[] notNullNoNullValue(T[] TArray, String string) {
        return JCValueEnforcer.notNullNoNullValue(TArray, () -> string);
    }

    public static <T> T[] notNullNoNullValue(T[] TArray, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(TArray, supplier);
        JCValueEnforcer.noNullValue(TArray, supplier);
        return TArray;
    }

    public static <T extends Iterable<?>> T notNullNoNullValue(T t, String string) {
        return JCValueEnforcer.notNullNoNullValue(t, () -> string);
    }

    public static <T extends Iterable<?>> T notNullNoNullValue(T t, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(t, supplier);
        JCValueEnforcer.noNullValue(t, supplier);
        return t;
    }

    public static <T extends Map<?, ?>> T notNullNoNullValue(T t, String string) {
        return JCValueEnforcer.notNullNoNullValue(t, () -> string);
    }

    public static <T extends Map<?, ?>> T notNullNoNullValue(T t, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(t, supplier);
        JCValueEnforcer.noNullValue(t, supplier);
        return t;
    }

    public static <T> T[] notEmptyNoNullValue(T[] TArray, String string) {
        return JCValueEnforcer.notEmptyNoNullValue(TArray, () -> string);
    }

    public static <T> T[] notEmptyNoNullValue(T[] TArray, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notEmpty(TArray, supplier);
        JCValueEnforcer.noNullValue(TArray, supplier);
        return TArray;
    }

    public static <T extends Iterable<?>> T notEmptyNoNullValue(T t, String string) {
        return JCValueEnforcer.notEmptyNoNullValue(t, () -> string);
    }

    public static <T extends Iterable<?>> T notEmptyNoNullValue(T t, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notEmpty(t, supplier);
        JCValueEnforcer.noNullValue(t, supplier);
        return t;
    }

    public static <T extends Map<?, ?>> T notEmptyNoNullValue(T t, String string) {
        return JCValueEnforcer.notEmptyNoNullValue(t, () -> string);
    }

    public static <T extends Map<?, ?>> T notEmptyNoNullValue(T t, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notEmpty(t, supplier);
        JCValueEnforcer.noNullValue(t, supplier);
        return t;
    }

    public static <T> T notNullNotEquals(T t, String string, @Nonnull T t2) {
        return JCValueEnforcer.notNullNotEquals(t, () -> string, t2);
    }

    public static <T> T notNullNotEquals(T t, @Nonnull Supplier<? extends String> supplier, @Nonnull T t2) {
        JCValueEnforcer.notNull(t, supplier);
        JCValueEnforcer.notNull(t2, "UnexpectedValue");
        if (JCValueEnforcer.isEnabled() && t.equals(t2)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' may not be equal to " + t2 + "!");
        }
        return t;
    }

    public static <T> T notNullAndEquals(T t, String string, @Nonnull T t2) {
        return JCValueEnforcer.notNullAndEquals(t, () -> string, t2);
    }

    public static <T> T notNullAndEquals(T t, @Nonnull Supplier<? extends String> supplier, @Nonnull T t2) {
        JCValueEnforcer.notNull(t, supplier);
        if (JCValueEnforcer.isEnabled() && !t.equals(t2)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' does not match the expected value. Passed value: " + t + " -- Expected value: " + t2);
        }
        return t;
    }

    public static <T> T isSame(T t, String string, @Nullable T t2) {
        return JCValueEnforcer.isSame(t, () -> string, t2);
    }

    public static <T> T isSame(T t, @Nonnull Supplier<? extends String> supplier, @Nullable T t2) {
        if (JCValueEnforcer.isEnabled() && t != t2) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' does not match the expected value. Passed value: " + t + " -- Expected value: " + t2);
        }
        return t;
    }

    public static <T> T isEqual(T t, @Nullable T t2, String string) {
        return JCValueEnforcer.isSame(t, () -> string, t2);
    }

    public static <T> T isEqual(T t, @Nullable T t2, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && t != t2) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' does not match the expected value. Passed value: " + t + " -- Expected value: " + t2);
        }
        return t;
    }

    public static void isEqual(int n, int n2, String string) {
        JCValueEnforcer.isEqual(n, n2, () -> string);
    }

    public static void isEqual(int n, int n2, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && n != n2) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' does not match the expected value. Passed value: " + n + " -- Expected value: " + n2);
        }
    }

    public static void isEqual(long l, long l2, String string) {
        JCValueEnforcer.isEqual(l, l2, () -> string);
    }

    public static void isEqual(long l, long l2, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && l != l2) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' does not match the expected value. Passed value: " + l + " -- Expected value: " + l2);
        }
    }

    public static void isEqual(double d, double d2, String string) {
        JCValueEnforcer.isEqual(d, d2, () -> string);
    }

    public static void isEqual(double d, double d2, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && Double.compare(d, d2) != 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' does not match the expected value. Passed value: " + d + " -- Expected value: " + d2);
        }
    }

    public static int isGE0(int n, String string) {
        return JCValueEnforcer.isGE0(n, () -> string);
    }

    public static int isGE0(int n, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && n < 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= 0! The current value is: " + n);
        }
        return n;
    }

    public static long isGE0(long l, String string) {
        return JCValueEnforcer.isGE0(l, () -> string);
    }

    public static long isGE0(long l, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && l < 0L) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= 0! The current value is: " + l);
        }
        return l;
    }

    public static short isGE0(short s, String string) {
        return JCValueEnforcer.isGE0(s, () -> string);
    }

    public static short isGE0(short s, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && s < 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= 0! The current value is: " + s);
        }
        return s;
    }

    public static double isGE0(double d, String string) {
        return JCValueEnforcer.isGE0(d, () -> string);
    }

    public static double isGE0(double d, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && d < 0.0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= 0! The current value is: " + d);
        }
        return d;
    }

    public static float isGE0(float f, String string) {
        return JCValueEnforcer.isGE0(f, () -> string);
    }

    public static float isGE0(float f, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && f < 0.0f) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= 0! The current value is: " + f);
        }
        return f;
    }

    public static BigDecimal isGE0(BigDecimal bigDecimal, String string) {
        return JCValueEnforcer.isGE0(bigDecimal, () -> string);
    }

    public static BigDecimal isGE0(BigDecimal bigDecimal, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(bigDecimal, supplier);
        if (JCValueEnforcer.isEnabled() && bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= 0! The current value is: " + bigDecimal);
        }
        return bigDecimal;
    }

    public static BigInteger isGE0(BigInteger bigInteger, String string) {
        return JCValueEnforcer.isGE0(bigInteger, () -> string);
    }

    public static BigInteger isGE0(BigInteger bigInteger, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(bigInteger, supplier);
        if (JCValueEnforcer.isEnabled() && bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= 0! The current value is: " + bigInteger);
        }
        return bigInteger;
    }

    public static int isGT0(int n, String string) {
        return JCValueEnforcer.isGT0(n, () -> string);
    }

    public static int isGT0(int n, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && n <= 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > 0! The current value is: " + n);
        }
        return n;
    }

    public static long isGT0(long l, String string) {
        return JCValueEnforcer.isGT0(l, () -> string);
    }

    public static long isGT0(long l, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && l <= 0L) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > 0! The current value is: " + l);
        }
        return l;
    }

    public static short isGT0(short s, String string) {
        return JCValueEnforcer.isGT0(s, () -> string);
    }

    public static short isGT0(short s, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && s <= 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > 0! The current value is: " + s);
        }
        return s;
    }

    public static double isGT0(double d, String string) {
        return JCValueEnforcer.isGT0(d, () -> string);
    }

    public static double isGT0(double d, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && d <= 0.0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > 0! The current value is: " + d);
        }
        return d;
    }

    public static float isGT0(float f, String string) {
        return JCValueEnforcer.isGT0(f, () -> string);
    }

    public static float isGT0(float f, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && f <= 0.0f) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > 0! The current value is: " + f);
        }
        return f;
    }

    public static BigDecimal isGT0(BigDecimal bigDecimal, String string) {
        return JCValueEnforcer.isGT0(bigDecimal, () -> string);
    }

    public static BigDecimal isGT0(BigDecimal bigDecimal, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(bigDecimal, supplier);
        if (JCValueEnforcer.isEnabled() && bigDecimal.compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > 0! The current value is: " + bigDecimal);
        }
        return bigDecimal;
    }

    public static BigInteger isGT0(BigInteger bigInteger, String string) {
        return JCValueEnforcer.isGT0(bigInteger, () -> string);
    }

    public static BigInteger isGT0(BigInteger bigInteger, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(bigInteger, supplier);
        if (JCValueEnforcer.isEnabled() && bigInteger.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > 0! The current value is: " + bigInteger);
        }
        return bigInteger;
    }

    public static int isLE0(int n, String string) {
        return JCValueEnforcer.isLE0(n, () -> string);
    }

    public static int isLE0(int n, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && n > 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be <= 0! The current value is: " + n);
        }
        return n;
    }

    public static long isLE0(long l, String string) {
        return JCValueEnforcer.isLE0(l, () -> string);
    }

    public static long isLE0(long l, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && l > 0L) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be <= 0! The current value is: " + l);
        }
        return l;
    }

    public static short isLE0(short s, String string) {
        return JCValueEnforcer.isLE0(s, () -> string);
    }

    public static short isLE0(short s, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && s > 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be <= 0! The current value is: " + s);
        }
        return s;
    }

    public static double isLE0(double d, String string) {
        return JCValueEnforcer.isLE0(d, () -> string);
    }

    public static double isLE0(double d, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && d > 0.0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be <= 0! The current value is: " + d);
        }
        return d;
    }

    public static float isLE0(float f, String string) {
        return JCValueEnforcer.isLE0(f, () -> string);
    }

    public static float isLE0(float f, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && f > 0.0f) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be <= 0! The current value is: " + f);
        }
        return f;
    }

    public static BigDecimal isLE0(BigDecimal bigDecimal, String string) {
        return JCValueEnforcer.isLE0(bigDecimal, () -> string);
    }

    public static BigDecimal isLE0(BigDecimal bigDecimal, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(bigDecimal, supplier);
        if (JCValueEnforcer.isEnabled() && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be <= 0! The current value is: " + bigDecimal);
        }
        return bigDecimal;
    }

    public static BigInteger isLE0(BigInteger bigInteger, String string) {
        return JCValueEnforcer.isLE0(bigInteger, () -> string);
    }

    public static BigInteger isLE0(BigInteger bigInteger, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(bigInteger, supplier);
        if (JCValueEnforcer.isEnabled() && bigInteger.compareTo(BigInteger.ZERO) > 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be <= 0! The current value is: " + bigInteger);
        }
        return bigInteger;
    }

    public static int isLT0(int n, String string) {
        return JCValueEnforcer.isLT0(n, () -> string);
    }

    public static int isLT0(int n, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && n >= 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be < 0! The current value is: " + n);
        }
        return n;
    }

    public static long isLT0(long l, String string) {
        return JCValueEnforcer.isLT0(l, () -> string);
    }

    public static long isLT0(long l, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && l >= 0L) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be < 0! The current value is: " + l);
        }
        return l;
    }

    public static short isLT0(short s, String string) {
        return JCValueEnforcer.isLT0(s, () -> string);
    }

    public static short isLT0(short s, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && s >= 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be < 0! The current value is: " + s);
        }
        return s;
    }

    public static double isLT0(double d, String string) {
        return JCValueEnforcer.isLT0(d, () -> string);
    }

    public static double isLT0(double d, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && d >= 0.0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be < 0! The current value is: " + d);
        }
        return d;
    }

    public static float isLT0(float f, String string) {
        return JCValueEnforcer.isLT0(f, () -> string);
    }

    public static float isLT0(float f, @Nonnull Supplier<? extends String> supplier) {
        if (JCValueEnforcer.isEnabled() && f >= 0.0f) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be < 0! The current value is: " + f);
        }
        return f;
    }

    public static BigDecimal isLT0(BigDecimal bigDecimal, String string) {
        return JCValueEnforcer.isLT0(bigDecimal, () -> string);
    }

    public static BigDecimal isLT0(BigDecimal bigDecimal, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(bigDecimal, supplier);
        if (JCValueEnforcer.isEnabled() && bigDecimal.compareTo(BigDecimal.ZERO) >= 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be < 0! The current value is: " + bigDecimal);
        }
        return bigDecimal;
    }

    public static BigInteger isLT0(BigInteger bigInteger, String string) {
        return JCValueEnforcer.isLT0(bigInteger, () -> string);
    }

    public static BigInteger isLT0(BigInteger bigInteger, @Nonnull Supplier<? extends String> supplier) {
        JCValueEnforcer.notNull(bigInteger, supplier);
        if (JCValueEnforcer.isEnabled() && bigInteger.compareTo(BigInteger.ZERO) >= 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be < 0! The current value is: " + bigInteger);
        }
        return bigInteger;
    }

    public static int isBetweenInclusive(int n, String string, int n2, int n3) {
        return JCValueEnforcer.isBetweenInclusive(n, () -> string, n2, n3);
    }

    public static int isBetweenInclusive(int n, @Nonnull Supplier<? extends String> supplier, int n2, int n3) {
        if (JCValueEnforcer.isEnabled() && (n < n2 || n > n3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= " + n2 + " and <= " + n3 + "! The current value is: " + n);
        }
        return n;
    }

    public static long isBetweenInclusive(long l, String string, long l2, long l3) {
        return JCValueEnforcer.isBetweenInclusive(l, () -> string, l2, l3);
    }

    public static long isBetweenInclusive(long l, @Nonnull Supplier<? extends String> supplier, long l2, long l3) {
        if (JCValueEnforcer.isEnabled() && (l < l2 || l > l3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= " + l2 + " and <= " + l3 + "! The current value is: " + l);
        }
        return l;
    }

    public static short isBetweenInclusive(short s, String string, short s2, short s3) {
        return JCValueEnforcer.isBetweenInclusive(s, () -> string, s2, s3);
    }

    public static short isBetweenInclusive(short s, @Nonnull Supplier<? extends String> supplier, short s2, short s3) {
        if (JCValueEnforcer.isEnabled() && (s < s2 || s > s3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= " + s2 + " and <= " + s3 + "! The current value is: " + s);
        }
        return s;
    }

    public static double isBetweenInclusive(double d, String string, double d2, double d3) {
        return JCValueEnforcer.isBetweenInclusive(d, () -> string, d2, d3);
    }

    public static double isBetweenInclusive(double d, @Nonnull Supplier<? extends String> supplier, double d2, double d3) {
        if (JCValueEnforcer.isEnabled() && (d < d2 || d > d3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= " + d2 + " and <= " + d3 + "! The current value is: " + d);
        }
        return d;
    }

    public static float isBetweenInclusive(float f, String string, float f2, float f3) {
        return JCValueEnforcer.isBetweenInclusive(f, () -> string, f2, f3);
    }

    public static float isBetweenInclusive(float f, @Nonnull Supplier<? extends String> supplier, float f2, float f3) {
        if (JCValueEnforcer.isEnabled() && (f < f2 || f > f3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= " + f2 + " and <= " + f3 + "! The current value is: " + f);
        }
        return f;
    }

    public static BigDecimal isBetweenInclusive(BigDecimal bigDecimal, String string, @Nonnull BigDecimal bigDecimal2, @Nonnull BigDecimal bigDecimal3) {
        return JCValueEnforcer.isBetweenInclusive(bigDecimal, () -> string, bigDecimal2, bigDecimal3);
    }

    public static BigDecimal isBetweenInclusive(BigDecimal bigDecimal, @Nonnull Supplier<? extends String> supplier, @Nonnull BigDecimal bigDecimal2, @Nonnull BigDecimal bigDecimal3) {
        JCValueEnforcer.notNull(bigDecimal, supplier);
        JCValueEnforcer.notNull(bigDecimal2, "LowerBoundInclusive");
        JCValueEnforcer.notNull(bigDecimal3, "UpperBoundInclusive");
        if (JCValueEnforcer.isEnabled() && (bigDecimal.compareTo(bigDecimal2) < 0 || bigDecimal.compareTo(bigDecimal3) > 0)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= " + bigDecimal2 + " and <= " + bigDecimal3 + "! The current value is: " + bigDecimal);
        }
        return bigDecimal;
    }

    public static BigInteger isBetweenInclusive(BigInteger bigInteger, String string, @Nonnull BigInteger bigInteger2, @Nonnull BigInteger bigInteger3) {
        return JCValueEnforcer.isBetweenInclusive(bigInteger, () -> string, bigInteger2, bigInteger3);
    }

    public static BigInteger isBetweenInclusive(BigInteger bigInteger, @Nonnull Supplier<? extends String> supplier, @Nonnull BigInteger bigInteger2, @Nonnull BigInteger bigInteger3) {
        JCValueEnforcer.notNull(bigInteger, supplier);
        JCValueEnforcer.notNull(bigInteger2, "LowerBoundInclusive");
        JCValueEnforcer.notNull(bigInteger3, "UpperBoundInclusive");
        if (JCValueEnforcer.isEnabled() && (bigInteger.compareTo(bigInteger2) < 0 || bigInteger.compareTo(bigInteger3) > 0)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= " + bigInteger2 + " and <= " + bigInteger3 + "! The current value is: " + bigInteger);
        }
        return bigInteger;
    }

    public static int isBetweenExclusive(int n, String string, int n2, int n3) {
        return JCValueEnforcer.isBetweenExclusive(n, () -> string, n2, n3);
    }

    public static int isBetweenExclusive(int n, @Nonnull Supplier<? extends String> supplier, int n2, int n3) {
        if (JCValueEnforcer.isEnabled() && (n <= n2 || n >= n3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > " + n2 + " and < " + n3 + "! The current value is: " + n);
        }
        return n;
    }

    public static long isBetweenExclusive(long l, String string, long l2, long l3) {
        return JCValueEnforcer.isBetweenExclusive(l, () -> string, l2, l3);
    }

    public static long isBetweenExclusive(long l, @Nonnull Supplier<? extends String> supplier, long l2, long l3) {
        if (JCValueEnforcer.isEnabled() && (l <= l2 || l >= l3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > " + l2 + " and < " + l3 + "! The current value is: " + l);
        }
        return l;
    }

    public static short isBetweenExclusive(short s, String string, short s2, short s3) {
        return JCValueEnforcer.isBetweenExclusive(s, () -> string, s2, s3);
    }

    public static short isBetweenExclusive(short s, @Nonnull Supplier<? extends String> supplier, short s2, short s3) {
        if (JCValueEnforcer.isEnabled() && (s <= s2 || s >= s3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > " + s2 + " and < " + s3 + "! The current value is: " + s);
        }
        return s;
    }

    public static double isBetweenExclusive(double d, String string, double d2, double d3) {
        return JCValueEnforcer.isBetweenExclusive(d, () -> string, d2, d3);
    }

    public static double isBetweenExclusive(double d, @Nonnull Supplier<? extends String> supplier, double d2, double d3) {
        if (JCValueEnforcer.isEnabled() && (d <= d2 || d >= d3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > " + d2 + " and < " + d3 + "! The current value is: " + d);
        }
        return d;
    }

    public static float isBetweenExclusive(float f, String string, float f2, float f3) {
        return JCValueEnforcer.isBetweenExclusive(f, () -> string, f2, f3);
    }

    public static float isBetweenExclusive(float f, @Nonnull Supplier<? extends String> supplier, float f2, float f3) {
        if (JCValueEnforcer.isEnabled() && (f <= f2 || f >= f3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > " + f2 + " and < " + f3 + "! The current value is: " + f);
        }
        return f;
    }

    public static BigDecimal isBetweenExclusive(BigDecimal bigDecimal, String string, @Nonnull BigDecimal bigDecimal2, @Nonnull BigDecimal bigDecimal3) {
        return JCValueEnforcer.isBetweenExclusive(bigDecimal, () -> string, bigDecimal2, bigDecimal3);
    }

    public static BigDecimal isBetweenExclusive(BigDecimal bigDecimal, @Nonnull Supplier<? extends String> supplier, @Nonnull BigDecimal bigDecimal2, @Nonnull BigDecimal bigDecimal3) {
        JCValueEnforcer.notNull(bigDecimal, supplier);
        JCValueEnforcer.notNull(bigDecimal2, "LowerBoundInclusive");
        JCValueEnforcer.notNull(bigDecimal3, "UpperBoundInclusive");
        if (JCValueEnforcer.isEnabled() && (bigDecimal.compareTo(bigDecimal2) <= 0 || bigDecimal.compareTo(bigDecimal3) >= 0)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > " + bigDecimal2 + " and < " + bigDecimal3 + "! The current value is: " + bigDecimal);
        }
        return bigDecimal;
    }

    public static BigInteger isBetweenExclusive(BigInteger bigInteger, String string, @Nonnull BigInteger bigInteger2, @Nonnull BigInteger bigInteger3) {
        return JCValueEnforcer.isBetweenExclusive(bigInteger, () -> string, bigInteger2, bigInteger3);
    }

    public static BigInteger isBetweenExclusive(BigInteger bigInteger, @Nonnull Supplier<? extends String> supplier, @Nonnull BigInteger bigInteger2, @Nonnull BigInteger bigInteger3) {
        JCValueEnforcer.notNull(bigInteger, supplier);
        JCValueEnforcer.notNull(bigInteger2, "LowerBoundInclusive");
        JCValueEnforcer.notNull(bigInteger3, "UpperBoundInclusive");
        if (JCValueEnforcer.isEnabled() && (bigInteger.compareTo(bigInteger2) <= 0 || bigInteger.compareTo(bigInteger3) >= 0)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > " + bigInteger2 + " and < " + bigInteger3 + "! The current value is: " + bigInteger);
        }
        return bigInteger;
    }

    private static void _isArrayOfsLen(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3) {
        JCValueEnforcer.isGE0(n2, "Offset");
        JCValueEnforcer.isGE0(n3, "Length");
        if (JCValueEnforcer.isEnabled() && n2 + n3 > n) {
            throw new IllegalArgumentException("Offset (" + n2 + ") + length (" + n3 + ") exceeds array length (" + n + ")");
        }
    }

    public static void isArrayOfsLen(Object[] objectArray, @Nonnegative int n, @Nonnegative int n2) {
        JCValueEnforcer.notNull(objectArray, "Array");
        JCValueEnforcer._isArrayOfsLen(objectArray.length, n, n2);
    }

    public static void isArrayOfsLen(boolean[] blArray, @Nonnegative int n, @Nonnegative int n2) {
        JCValueEnforcer.notNull(blArray, "Array");
        JCValueEnforcer._isArrayOfsLen(blArray.length, n, n2);
    }

    public static void isArrayOfsLen(byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        JCValueEnforcer.notNull(byArray, "Array");
        JCValueEnforcer._isArrayOfsLen(byArray.length, n, n2);
    }

    public static void isArrayOfsLen(char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        JCValueEnforcer.notNull(cArray, "Array");
        JCValueEnforcer._isArrayOfsLen(cArray.length, n, n2);
    }

    public static void isArrayOfsLen(double[] dArray, @Nonnegative int n, @Nonnegative int n2) {
        JCValueEnforcer.notNull(dArray, "Array");
        JCValueEnforcer._isArrayOfsLen(dArray.length, n, n2);
    }

    public static void isArrayOfsLen(float[] fArray, @Nonnegative int n, @Nonnegative int n2) {
        JCValueEnforcer.notNull(fArray, "Array");
        JCValueEnforcer._isArrayOfsLen(fArray.length, n, n2);
    }

    public static void isArrayOfsLen(int[] nArray, @Nonnegative int n, @Nonnegative int n2) {
        JCValueEnforcer.notNull(nArray, "Array");
        JCValueEnforcer._isArrayOfsLen(nArray.length, n, n2);
    }

    public static void isArrayOfsLen(long[] lArray, @Nonnegative int n, @Nonnegative int n2) {
        JCValueEnforcer.notNull(lArray, "Array");
        JCValueEnforcer._isArrayOfsLen(lArray.length, n, n2);
    }

    public static void isArrayOfsLen(short[] sArray, @Nonnegative int n, @Nonnegative int n2) {
        JCValueEnforcer.notNull(sArray, "Array");
        JCValueEnforcer._isArrayOfsLen(sArray.length, n, n2);
    }
}

