/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.writer;

import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.SourcePrintWriter;
import com.helger.jcodemodel.util.JCValueEnforcer;
import com.helger.jcodemodel.util.UnicodeEscapeWriter;
import com.helger.jcodemodel.writer.JavaUnicodeEscapeWriter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractCodeWriter
implements Closeable {
    private final Charset m_aEncoding;
    private final String m_sNewLine;

    protected AbstractCodeWriter(@Nullable Charset charset, @Nonnull String string) {
        JCValueEnforcer.notNull(string, "NewLine");
        this.m_aEncoding = charset;
        this.m_sNewLine = string;
    }

    @Nullable
    public Charset encoding() {
        return this.m_aEncoding;
    }

    @Nonnull
    public String getNewLine() {
        return this.m_sNewLine;
    }

    @Nonnull
    public abstract OutputStream openBinary(@Nonnull String var1, @Nonnull String var2) throws IOException;

    @Nonnull
    protected static String toDirName(@Nonnull JPackage jPackage) {
        return jPackage.isUnnamed() ? "" : jPackage.name().replace('.', '/');
    }

    @Nonnull
    public final OutputStream openBinary(@Nonnull JPackage jPackage, @Nonnull String string) throws IOException {
        return this.openBinary(AbstractCodeWriter.toDirName(jPackage), string);
    }

    @Nonnull
    public SourcePrintWriter openSource(@Nonnull JPackage jPackage, @Nonnull String string) throws IOException {
        UnicodeEscapeWriter unicodeEscapeWriter;
        OutputStream outputStream = this.openBinary(jPackage, string);
        OutputStreamWriter outputStreamWriter = this.m_aEncoding != null ? new OutputStreamWriter(outputStream, this.m_aEncoding) : new OutputStreamWriter(outputStream);
        try {
            unicodeEscapeWriter = new JavaUnicodeEscapeWriter(outputStreamWriter);
        }
        catch (Exception exception) {
            unicodeEscapeWriter = new UnicodeEscapeWriter(outputStreamWriter);
        }
        return new SourcePrintWriter(new BufferedWriter(unicodeEscapeWriter), this.m_sNewLine);
    }

    @Override
    public abstract void close() throws IOException;
}

