/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.writer;

import com.helger.jcodemodel.writer.AbstractCodeWriter;
import com.helger.jcodemodel.writer.JCMWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.annotation.Nonnull;

public class SingleStreamCodeWriter
extends AbstractCodeWriter {
    private final PrintStream m_aPS;
    private final boolean m_bDoClose;

    public SingleStreamCodeWriter(@Nonnull OutputStream outputStream) {
        this(outputStream, JCMWriter.getDefaultNewLine());
    }

    public SingleStreamCodeWriter(@Nonnull OutputStream outputStream, @Nonnull String string) {
        super(null, string);
        this.m_bDoClose = outputStream != System.out && outputStream != System.err;
        this.m_aPS = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream);
    }

    @Override
    public OutputStream openBinary(@Nonnull String string, @Nonnull String string2) throws IOException {
        String string3 = string;
        if (string3.length() > 0) {
            string3 = string3 + '/';
        }
        this.m_aPS.println("-----------------------------------" + string3 + string2 + "-----------------------------------");
        return new FilterOutputStream(this.m_aPS){

            @Override
            public void close() {
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.m_aPS.flush();
        if (this.m_bDoClose) {
            this.m_aPS.close();
        }
    }
}

