/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClassContainer;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.EWildcardBoundMode;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.JArrayClass;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JLambdaMethodRef;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JNarrowedClass;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.JPrimitiveType;
import com.helger.jcodemodel.JTypeVar;
import com.helger.jcodemodel.JTypeWildcard;
import com.helger.jcodemodel.JVar;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractJClass
extends AbstractJType {
    public static final JTypeVar[] EMPTY_ARRAY = new JTypeVar[0];
    private final JCodeModel m_aOwner;
    private JArrayClass m_aArrayClass;

    protected AbstractJClass(@Nonnull JCodeModel jCodeModel) {
        this.m_aOwner = JCValueEnforcer.notNull(jCodeModel, "Owner");
    }

    @Override
    public abstract String name();

    public abstract JPackage _package();

    @Nullable
    public AbstractJClass outer() {
        return null;
    }

    @Override
    @Nonnull
    public final JCodeModel owner() {
        return this.m_aOwner;
    }

    @Nullable
    public abstract AbstractJClass _extends();

    @Nonnull
    public abstract Iterator<AbstractJClass> _implements();

    public abstract boolean isInterface();

    public abstract boolean isAbstract();

    @Nullable
    public JPrimitiveType getPrimitiveType() {
        return null;
    }

    @Override
    @Deprecated
    public final AbstractJClass boxify() {
        return this;
    }

    @Override
    @Nonnull
    public final AbstractJType unboxify() {
        JPrimitiveType jPrimitiveType = this.getPrimitiveType();
        return jPrimitiveType == null ? this : jPrimitiveType;
    }

    @Override
    @Nonnull
    public AbstractJClass erasure() {
        return this;
    }

    @Nullable
    public final AbstractJClass getBaseClass(@Nonnull AbstractJClass abstractJClass) {
        Object object;
        if (this.erasure().equals(abstractJClass)) {
            return this;
        }
        AbstractJClass abstractJClass2 = this._extends();
        if (abstractJClass2 != null && (object = abstractJClass2.getBaseClass(abstractJClass)) != null) {
            return object;
        }
        object = this._implements();
        while (object.hasNext()) {
            AbstractJClass abstractJClass3 = ((AbstractJClass)object.next()).getBaseClass(abstractJClass);
            if (abstractJClass3 == null) continue;
            return abstractJClass3;
        }
        return null;
    }

    @Nullable
    public final AbstractJClass getBaseClass(@Nonnull Class<?> clazz) {
        return this.getBaseClass(this.owner().ref(clazz));
    }

    @Override
    @Nonnull
    public JArrayClass array() {
        if (this.m_aArrayClass == null) {
            this.m_aArrayClass = new JArrayClass(this.owner(), this);
        }
        return this.m_aArrayClass;
    }

    @Nonnull
    public JNarrowedClass narrow(@Nonnull Class<?> clazz) {
        return this.narrow(this.owner().ref(clazz));
    }

    @Nonnull
    public AbstractJClass narrow(Class<?> ... classArray) {
        ArrayList<AbstractJClass> arrayList = new ArrayList<AbstractJClass>(classArray.length);
        for (Class<?> clazz : classArray) {
            arrayList.add(this.owner().ref(clazz));
        }
        return this.narrow(arrayList);
    }

    @Nonnull
    public JNarrowedClass narrow(@Nonnull AbstractJClass abstractJClass) {
        return new JNarrowedClass(this, abstractJClass);
    }

    @Nonnull
    public JNarrowedClass narrow(@Nonnull AbstractJType abstractJType) {
        return this.narrow(abstractJType.boxify());
    }

    @Nonnull
    public AbstractJClass narrow(AbstractJClass ... abstractJClassArray) {
        return new JNarrowedClass(this, Arrays.asList((Object[])abstractJClassArray.clone()));
    }

    @Nonnull
    public AbstractJClass narrow(@Nonnull List<? extends AbstractJClass> list) {
        return new JNarrowedClass(this, new ArrayList<AbstractJClass>(list));
    }

    @Nonnull
    public AbstractJClass narrowEmpty() {
        return new JNarrowedClass(this, new ArrayList());
    }

    @Nonnull
    public AbstractJClass narrowAny() {
        return this.narrow(this.owner().wildcard());
    }

    @Nonnull
    public List<? extends AbstractJClass> getTypeParameters() {
        return Collections.emptyList();
    }

    @Nonnull
    public JTypeVar[] typeParams() {
        return EMPTY_ARRAY;
    }

    public final boolean isParameterized() {
        return this.erasure() != this;
    }

    @Nonnull
    @Deprecated
    public final JTypeWildcard wildcard() {
        return this.wildcardExtends();
    }

    @Nonnull
    public final JTypeWildcard wildcardExtends() {
        return this.wildcard(EWildcardBoundMode.EXTENDS);
    }

    @Nonnull
    public final JTypeWildcard wildcardSuper() {
        return this.wildcard(EWildcardBoundMode.SUPER);
    }

    @Nonnull
    public final JTypeWildcard wildcard(@Nonnull EWildcardBoundMode eWildcardBoundMode) {
        return new JTypeWildcard(this, eWildcardBoundMode);
    }

    @Nonnull
    protected abstract AbstractJClass substituteParams(@Nonnull JTypeVar[] var1, @Nonnull List<? extends AbstractJClass> var2);

    @Nonnull
    public Collection<AbstractJClassContainer<?>> getAllInnerClasses() {
        if (this instanceof AbstractJClassContainer) {
            Collection<AbstractJClassContainer<?>> collection = ((AbstractJClassContainer)this).classes();
            return collection;
        }
        return Collections.emptyList();
    }

    @Nullable
    public AbstractJClassContainer<?> getInnerClass(@Nullable String string) {
        for (AbstractJClassContainer<?> abstractJClassContainer : this.getAllInnerClasses()) {
            if (!abstractJClassContainer.name().equals(string)) continue;
            return abstractJClassContainer;
        }
        return null;
    }

    @Nonnull
    public final IJExpression dotclass() {
        return JExpr.dotClass(this);
    }

    @Nonnull
    public final JInvocation staticInvoke(@Nonnull JMethod jMethod) {
        return new JInvocation(this.owner(), (IJGenerable)this, jMethod);
    }

    @Nonnull
    public final JInvocation staticInvoke(@Nonnull String string) {
        return new JInvocation(this.owner(), (IJGenerable)this, string);
    }

    @Nonnull
    public final JFieldRef staticRef(@Nonnull String string) {
        return new JFieldRef((AbstractJType)this, string);
    }

    @Nonnull
    public final JFieldRef staticRef(@Nonnull JVar jVar) {
        return new JFieldRef((AbstractJType)this, jVar);
    }

    @Nonnull
    public final JLambdaMethodRef methodRefNew() {
        return JLambdaMethodRef.createForNew(this);
    }

    @Nonnull
    public final JLambdaMethodRef methodRef(@Nonnull String string) {
        return new JLambdaMethodRef(this, string);
    }

    @Nonnull
    public final IJExpression enumConstantRef(@Nonnull String string) {
        return JExpr.enumConstantRef(this, string);
    }

    @Nonnull
    public final IJExpression enumConstantRef(@Nonnull Enum<?> enum_) {
        return this.enumConstantRef(enum_.name());
    }

    @Override
    public void generate(@Nonnull IJFormatter iJFormatter) {
        iJFormatter.type(this);
    }

    void printLink(@Nonnull IJFormatter iJFormatter) {
        iJFormatter.print("{@link ").generable(this).print('}');
    }

    @Override
    public String toString() {
        return this.getClass().getName() + '(' + this.fullName() + ')';
    }
}

