/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.JArrayCompRef;
import com.helger.jcodemodel.JCast;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JOp;
import com.helger.jcodemodel.JVar;
import javax.annotation.Nonnull;

public interface IJExpression
extends IJGenerable {
    @Nonnull
    default public IJExpression minus() {
        return JOp.minus(this);
    }

    @Nonnull
    default public IJExpression not() {
        return JOp.not(this);
    }

    @Nonnull
    default public IJExpression complement() {
        return JOp.complement(this);
    }

    @Nonnull
    default public IJExpression incr() {
        return this.postincr();
    }

    @Nonnull
    default public IJExpression postincr() {
        return JOp.postincr(this);
    }

    @Nonnull
    default public IJExpression preincr() {
        return JOp.preincr(this);
    }

    @Nonnull
    default public IJExpression decr() {
        return this.postdecr();
    }

    @Nonnull
    default public IJExpression postdecr() {
        return JOp.postdecr(this);
    }

    @Nonnull
    default public IJExpression predecr() {
        return JOp.predecr(this);
    }

    @Nonnull
    default public IJExpression plus(@Nonnull IJExpression iJExpression) {
        return JOp.plus(this, iJExpression);
    }

    @Nonnull
    default public IJExpression plus(double d) {
        return this.plus(JExpr.lit(d));
    }

    @Nonnull
    default public IJExpression plus(float f) {
        return this.plus(JExpr.lit(f));
    }

    @Nonnull
    default public IJExpression plus(int n) {
        return this.plus(JExpr.lit(n));
    }

    @Nonnull
    default public IJExpression plus(long l) {
        return this.plus(JExpr.lit(l));
    }

    @Nonnull
    default public IJExpression plus(@Nonnull String string) {
        return this.plus(JExpr.lit(string));
    }

    @Nonnull
    default public IJExpression minus(@Nonnull IJExpression iJExpression) {
        return JOp.minus(this, iJExpression);
    }

    @Nonnull
    default public IJExpression minus(double d) {
        return this.minus(JExpr.lit(d));
    }

    @Nonnull
    default public IJExpression minus(float f) {
        return this.minus(JExpr.lit(f));
    }

    @Nonnull
    default public IJExpression minus(int n) {
        return this.minus(JExpr.lit(n));
    }

    @Nonnull
    default public IJExpression minus(long l) {
        return this.minus(JExpr.lit(l));
    }

    @Nonnull
    default public IJExpression mul(@Nonnull IJExpression iJExpression) {
        return JOp.mul(this, iJExpression);
    }

    @Nonnull
    default public IJExpression mul(double d) {
        return this.mul(JExpr.lit(d));
    }

    @Nonnull
    default public IJExpression mul(float f) {
        return this.mul(JExpr.lit(f));
    }

    @Nonnull
    default public IJExpression mul(int n) {
        return this.mul(JExpr.lit(n));
    }

    @Nonnull
    default public IJExpression mul(long l) {
        return this.mul(JExpr.lit(l));
    }

    @Nonnull
    default public IJExpression div(@Nonnull IJExpression iJExpression) {
        return JOp.div(this, iJExpression);
    }

    @Nonnull
    default public IJExpression div(double d) {
        return this.div(JExpr.lit(d));
    }

    @Nonnull
    default public IJExpression div(float f) {
        return this.div(JExpr.lit(f));
    }

    @Nonnull
    default public IJExpression div(int n) {
        return this.div(JExpr.lit(n));
    }

    @Nonnull
    default public IJExpression div(long l) {
        return this.div(JExpr.lit(l));
    }

    @Nonnull
    default public IJExpression mod(@Nonnull IJExpression iJExpression) {
        return JOp.mod(this, iJExpression);
    }

    @Nonnull
    default public IJExpression mod(int n) {
        return this.mod(JExpr.lit(n));
    }

    @Nonnull
    default public IJExpression mod(long l) {
        return this.mod(JExpr.lit(l));
    }

    @Nonnull
    default public IJExpression shl(@Nonnull IJExpression iJExpression) {
        return JOp.shl(this, iJExpression);
    }

    @Nonnull
    default public IJExpression shl(int n) {
        return this.shl(JExpr.lit(n));
    }

    @Nonnull
    default public IJExpression shr(@Nonnull IJExpression iJExpression) {
        return JOp.shr(this, iJExpression);
    }

    @Nonnull
    default public IJExpression shr(int n) {
        return this.shr(JExpr.lit(n));
    }

    @Nonnull
    default public IJExpression shrz(@Nonnull IJExpression iJExpression) {
        return JOp.shrz(this, iJExpression);
    }

    @Nonnull
    default public IJExpression shrz(int n) {
        return this.shrz(JExpr.lit(n));
    }

    @Nonnull
    default public IJExpression band(@Nonnull IJExpression iJExpression) {
        return JOp.band(this, iJExpression);
    }

    @Nonnull
    default public IJExpression bor(@Nonnull IJExpression iJExpression) {
        return JOp.bor(this, iJExpression);
    }

    @Nonnull
    default public IJExpression cand(@Nonnull IJExpression iJExpression) {
        return JOp.cand(this, iJExpression);
    }

    @Nonnull
    default public IJExpression cor(@Nonnull IJExpression iJExpression) {
        return JOp.cor(this, iJExpression);
    }

    @Nonnull
    default public IJExpression xor(@Nonnull IJExpression iJExpression) {
        return JOp.xor(this, iJExpression);
    }

    @Nonnull
    default public IJExpression lt(@Nonnull IJExpression iJExpression) {
        return JOp.lt(this, iJExpression);
    }

    @Nonnull
    default public IJExpression lt(int n) {
        return this.lt(JExpr.lit(n));
    }

    @Nonnull
    default public IJExpression lt0() {
        return this.lt(0);
    }

    @Nonnull
    default public IJExpression lte(@Nonnull IJExpression iJExpression) {
        return JOp.lte(this, iJExpression);
    }

    @Nonnull
    default public IJExpression lte(int n) {
        return this.lte(JExpr.lit(n));
    }

    @Nonnull
    default public IJExpression lte0() {
        return this.lte(0);
    }

    @Nonnull
    default public IJExpression gt(@Nonnull IJExpression iJExpression) {
        return JOp.gt(this, iJExpression);
    }

    @Nonnull
    default public IJExpression gt(int n) {
        return this.gt(JExpr.lit(n));
    }

    @Nonnull
    default public IJExpression gt0() {
        return this.gt(0);
    }

    @Nonnull
    default public IJExpression gte(@Nonnull IJExpression iJExpression) {
        return JOp.gte(this, iJExpression);
    }

    @Nonnull
    default public IJExpression gte(int n) {
        return this.gte(JExpr.lit(n));
    }

    @Nonnull
    default public IJExpression gte0() {
        return this.gte(0);
    }

    @Nonnull
    default public IJExpression eq(@Nonnull IJExpression iJExpression) {
        return JOp.eq(this, iJExpression);
    }

    @Nonnull
    default public IJExpression eqNull() {
        return this.eq(JExpr._null());
    }

    @Nonnull
    default public IJExpression eq0() {
        return this.eq(JExpr.lit(0));
    }

    @Nonnull
    default public IJExpression ne(@Nonnull IJExpression iJExpression) {
        return JOp.ne(this, iJExpression);
    }

    @Nonnull
    default public IJExpression neNull() {
        return this.ne(JExpr._null());
    }

    @Nonnull
    default public IJExpression ne0() {
        return this.ne(JExpr.lit(0));
    }

    @Nonnull
    default public IJExpression _instanceof(@Nonnull AbstractJType abstractJType) {
        return JOp._instanceof(this, abstractJType);
    }

    @Nonnull
    default public JInvocation invoke(@Nonnull JMethod jMethod) {
        return JExpr.invoke(this, jMethod);
    }

    @Nonnull
    default public JInvocation invoke(@Nonnull String string) {
        return JExpr.invoke(this, string);
    }

    @Nonnull
    default public JFieldRef ref(@Nonnull JVar jVar) {
        return JExpr.ref(this, jVar);
    }

    @Nonnull
    default public JFieldRef ref(@Nonnull String string) {
        return JExpr.ref(this, string);
    }

    @Nonnull
    default public JArrayCompRef component(@Nonnull IJExpression iJExpression) {
        return JExpr.component(this, iJExpression);
    }

    @Nonnull
    default public JArrayCompRef component(int n) {
        return this.component(JExpr.lit(n));
    }

    @Nonnull
    default public JArrayCompRef component0() {
        return this.component(0);
    }

    @Nonnull
    default public JCast castTo(@Nonnull AbstractJType abstractJType) {
        return JExpr.cast(abstractJType, this);
    }
}

