/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.ChangeInV4;
import com.helger.jcodemodel.EClassType;
import com.helger.jcodemodel.JAnonymousClass;
import com.helger.jcodemodel.JArrayClass;
import com.helger.jcodemodel.JCodeModelException;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JDirectClass;
import com.helger.jcodemodel.JErrorClass;
import com.helger.jcodemodel.JNullType;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.JPrimitiveType;
import com.helger.jcodemodel.JReferencedClass;
import com.helger.jcodemodel.JResourceAlreadyExistsException;
import com.helger.jcodemodel.JResourceDir;
import com.helger.jcodemodel.meta.CodeModelBuildingException;
import com.helger.jcodemodel.meta.ErrorTypeFound;
import com.helger.jcodemodel.meta.JCodeModelJavaxLangModelAdapter;
import com.helger.jcodemodel.util.EFileSystemConvention;
import com.helger.jcodemodel.util.FSName;
import com.helger.jcodemodel.util.IFileSystemConvention;
import com.helger.jcodemodel.util.JCFilenameHelper;
import com.helger.jcodemodel.util.JCSecureLoader;
import com.helger.jcodemodel.util.JCStringHelper;
import com.helger.jcodemodel.util.JCValueEnforcer;
import com.helger.jcodemodel.writer.AbstractCodeWriter;
import com.helger.jcodemodel.writer.FileCodeWriter;
import com.helger.jcodemodel.writer.JCMWriter;
import com.helger.jcodemodel.writer.ProgressCodeWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class JCodeModel
implements Serializable {
    private static final String SEPARATOR_TWICE = JResourceDir.SEPARATOR_STR + JResourceDir.SEPARATOR_STR;
    static final Map<Class<?>, Class<?>> s_aPrimitiveToBox;
    static final Map<Class<?>, Class<?>> s_aBoxToPrimitive;
    private IFileSystemConvention m_aFSConvention;
    private final Map<String, JPackage> m_aPackages = new HashMap<String, JPackage>();
    private final Map<FSName, JResourceDir> m_aResourceDirs = new HashMap<FSName, JResourceDir>();
    private final Map<Class<?>, JReferencedClass> m_aRefClasses = new HashMap();
    public final JNullType NULL = new JNullType(this);
    public final JPrimitiveType BOOLEAN = new JPrimitiveType(this, "boolean", Boolean.class, true);
    public final JPrimitiveType BYTE = new JPrimitiveType(this, "byte", Byte.class, true);
    public final JPrimitiveType CHAR = new JPrimitiveType(this, "char", Character.class, true);
    public final JPrimitiveType DOUBLE = new JPrimitiveType(this, "double", Double.class, true);
    public final JPrimitiveType FLOAT = new JPrimitiveType(this, "float", Float.class, true);
    public final JPrimitiveType INT = new JPrimitiveType(this, "int", Integer.class, true);
    public final JPrimitiveType LONG = new JPrimitiveType(this, "long", Long.class, true);
    public final JPrimitiveType SHORT = new JPrimitiveType(this, "short", Short.class, true);
    public final JPrimitiveType VOID = new JPrimitiveType(this, "void", Void.class, false);
    private AbstractJClass m_aWildcard;
    @Deprecated
    @ChangeInV4
    private Charset m_aBuildingCharset;
    @Deprecated
    @ChangeInV4
    private String m_sBuildingNewLine = JCMWriter.getDefaultNewLine();
    private final Set<AbstractJClass> m_aDontImportClasses = new HashSet<AbstractJClass>();

    @Deprecated
    @ChangeInV4
    public static boolean isFileSystemCaseSensitive() {
        return EFileSystemConvention.DEFAULT.isCaseSensistive();
    }

    public JCodeModel() {
        this(EFileSystemConvention.DEFAULT);
    }

    public JCodeModel(@Nonnull IFileSystemConvention iFileSystemConvention) {
        JCValueEnforcer.notNull(iFileSystemConvention, "FSConvention");
        this.m_aFSConvention = iFileSystemConvention;
    }

    @Nonnull
    public final IFileSystemConvention getFileSystemConvention() {
        return this.m_aFSConvention;
    }

    @Nonnull
    public final JCodeModel setFileSystemConvention(@Nonnull IFileSystemConvention iFileSystemConvention) throws JCodeModelException {
        JCValueEnforcer.notNull(iFileSystemConvention, "FSConvention");
        if (!this.m_aPackages.isEmpty() || !this.m_aResourceDirs.isEmpty()) {
            throw new JCodeModelException("The FileSystem convention cannot be changed if a package or a resource directory already exists.");
        }
        this.m_aFSConvention = iFileSystemConvention;
        return this;
    }

    @Nonnull
    public JPackage _package(@Nonnull String string2) {
        return this.m_aPackages.computeIfAbsent(string2, string -> new JPackage((String)string, this));
    }

    @Nonnull
    public JPackage rootPackage() {
        return this._package("");
    }

    @Nonnull
    public Iterator<JPackage> packages() {
        return this.m_aPackages.values().iterator();
    }

    @Nonnull
    public List<JPackage> getAllPackages() {
        return new ArrayList<JPackage>(this.m_aPackages.values());
    }

    @Nonnull
    private static String _unifyPath(@Nonnull String string) {
        String string2 = JCFilenameHelper.getPathUsingUnixSeparator(string);
        string2 = JCStringHelper.replaceAllRepeatedly(string2, SEPARATOR_TWICE, JResourceDir.SEPARATOR_STR);
        string2 = JCFilenameHelper.ensurePathEndingWithoutSeparator(string2);
        return string2;
    }

    @Nonnull
    private FSName _createFSName(@Nonnull String string) {
        if (this.m_aFSConvention.isCaseSensistive()) {
            return FSName.createCaseSensitive(string);
        }
        return FSName.createCaseInsensitive(string);
    }

    @Nonnull
    public JResourceDir resourceDir(@Nonnull String string) throws JCodeModelException {
        JResourceDir jResourceDir;
        JCValueEnforcer.notNull(string, "Name");
        String string2 = JCodeModel._unifyPath(string);
        if (string2.startsWith(JResourceDir.SEPARATOR_STR)) {
            throw new IllegalArgumentException("A resource directory may not be an absolute path: '" + string + "'");
        }
        JResourceDir jResourceDir2 = jResourceDir = this.m_aResourceDirs.computeIfAbsent(this._createFSName(""), fSName -> JResourceDir.root(this));
        String string3 = "";
        JResourceDir jResourceDir3 = jResourceDir;
        for (String string4 : JCStringHelper.getExplodedArray('/', string2)) {
            if (string3.length() > 0) {
                string3 = string3 + '/';
            }
            string3 = string3 + string4;
            if (jResourceDir2.hasResourceFile(string4)) {
                throw new JResourceAlreadyExistsException(jResourceDir2.fullChildName(string4));
            }
            JResourceDir jResourceDir4 = jResourceDir2;
            jResourceDir2 = jResourceDir3 = this.m_aResourceDirs.computeIfAbsent(this._createFSName(string3), fSName -> new JResourceDir(this, jResourceDir4, fSName.getName()));
        }
        return jResourceDir3;
    }

    @Nonnull
    public JResourceDir rootResourceDir() {
        try {
            return this.resourceDir("");
        }
        catch (JCodeModelException jCodeModelException) {
            throw new IllegalStateException("This is indeed unexpected", jCodeModelException);
        }
    }

    public boolean containsResourceDir(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String string2 = JCodeModel._unifyPath(string);
        return this.m_aResourceDirs.containsKey(this._createFSName(string2));
    }

    @Nonnull
    public Iterator<JResourceDir> resourceDirs() {
        return this.m_aResourceDirs.values().iterator();
    }

    @Nonnull
    public List<JResourceDir> getAllResourceDirs() {
        return new ArrayList<JResourceDir>(this.m_aResourceDirs.values());
    }

    @Nonnull
    public JDefinedClass _class(int n, @Nonnull String string, @Nonnull EClassType eClassType) throws JCodeModelException {
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            return this.rootPackage()._class(n, string, eClassType);
        }
        return this._package(string.substring(0, n2))._class(n, string.substring(n2 + 1), eClassType);
    }

    @Nonnull
    public JDefinedClass _class(@Nonnull String string) throws JCodeModelException {
        return this._class(string, EClassType.CLASS);
    }

    @Nonnull
    public JDefinedClass _class(int n, @Nonnull String string) throws JCodeModelException {
        return this._class(n, string, EClassType.CLASS);
    }

    @Nonnull
    public JDefinedClass _class(@Nonnull String string, @Nonnull EClassType eClassType) throws JCodeModelException {
        return this._class(1, string, eClassType);
    }

    @Nonnull
    public JDirectClass directClass(@Nonnull String string) {
        return this.directClass(EClassType.CLASS, string);
    }

    @Nonnull
    public JDirectClass directClass(@Nonnull EClassType eClassType, @Nonnull String string) {
        return new JDirectClass(this, null, eClassType, string);
    }

    @Nonnull
    public JErrorClass errorClass(@Nonnull String string) {
        return this.errorClass(string, null);
    }

    @Nonnull
    public JErrorClass errorClass(@Nonnull String string, @Nullable String string2) {
        return new JErrorClass(this, string, string2);
    }

    public boolean buildsErrorTypeRefs() {
        for (JPackage jPackage : this.getAllPackages()) {
            if (!jPackage.buildsErrorTypeRefs()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public JDefinedClass _getClass(@Nonnull String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return this.rootPackage()._getClass(string);
        }
        return this._package(string.substring(0, n))._getClass(string.substring(n + 1));
    }

    @Nonnull
    public JAnonymousClass anonymousClass(@Nonnull AbstractJClass abstractJClass) {
        return new JAnonymousClass(abstractJClass);
    }

    @Nonnull
    public JAnonymousClass anonymousClass(@Nonnull Class<?> clazz) {
        return this.anonymousClass(this.ref(clazz));
    }

    @Nullable
    @Deprecated
    @ChangeInV4
    public Charset getBuildingCharset() {
        return this.m_aBuildingCharset;
    }

    @Nonnull
    @Deprecated
    @ChangeInV4
    public JCodeModel setBuildingCharset(@Nullable Charset charset) {
        this.m_aBuildingCharset = charset;
        return this;
    }

    @Deprecated
    @ChangeInV4
    public String getBuildingNewLine() {
        return this.m_sBuildingNewLine;
    }

    @Nonnull
    @Deprecated
    @ChangeInV4
    public JCodeModel setBuildingNewLine(@Nonnull String string) {
        JCValueEnforcer.notEmpty(string, "NewLine");
        this.m_sBuildingNewLine = string;
        return this;
    }

    @Deprecated
    @ChangeInV4
    public void build(@Nonnull File file, @Nullable PrintStream printStream) throws IOException {
        this.build(file, file, printStream);
    }

    @Deprecated
    @ChangeInV4
    public void build(@Nonnull File file, @Nonnull File file2, @Nullable PrintStream printStream) throws IOException {
        AbstractCodeWriter abstractCodeWriter = new FileCodeWriter(file2, this.m_aBuildingCharset, this.m_sBuildingNewLine);
        AbstractCodeWriter abstractCodeWriter2 = new FileCodeWriter(file, this.m_aBuildingCharset, this.m_sBuildingNewLine);
        if (printStream != null) {
            abstractCodeWriter2 = new ProgressCodeWriter(abstractCodeWriter2, printStream::println);
            abstractCodeWriter = new ProgressCodeWriter(abstractCodeWriter, printStream::println);
        }
        this.build(abstractCodeWriter2, abstractCodeWriter);
    }

    @Deprecated
    @ChangeInV4
    public void build(@Nonnull File file) throws IOException {
        this.build(file, System.out);
    }

    @Deprecated
    @ChangeInV4
    public void build(@Nonnull File file, @Nonnull File file2) throws IOException {
        this.build(file, file2, System.out);
    }

    @Deprecated
    @ChangeInV4
    public void build(@Nonnull AbstractCodeWriter abstractCodeWriter) throws IOException {
        this.build(abstractCodeWriter, abstractCodeWriter);
    }

    @Deprecated
    @ChangeInV4
    public void build(@Nonnull AbstractCodeWriter abstractCodeWriter, @Nonnull AbstractCodeWriter abstractCodeWriter2) throws IOException {
        new JCMWriter(this).setCharset(this.m_aBuildingCharset).setNewLine(this.m_sBuildingNewLine).build(abstractCodeWriter, abstractCodeWriter2);
    }

    @Nonnegative
    public int countArtifacts() {
        int n = 0;
        for (JPackage iJOwned : new ArrayList<JPackage>(this.m_aPackages.values())) {
            n += iJOwned.countArtifacts();
        }
        for (JResourceDir jResourceDir : new ArrayList<JResourceDir>(this.m_aResourceDirs.values())) {
            n += jResourceDir.countArtifacts();
        }
        return n;
    }

    @Nonnull
    public AbstractJClass ref(@Nonnull Class<?> clazz) {
        JReferencedClass jReferencedClass = this.m_aRefClasses.get(clazz);
        if (jReferencedClass == null) {
            if (clazz.isPrimitive()) {
                throw new IllegalArgumentException(clazz + " is a primitive");
            }
            if (clazz.isArray()) {
                Class<?> clazz2 = clazz.getComponentType();
                return new JArrayClass(this, this._ref(clazz2));
            }
            jReferencedClass = new JReferencedClass(this, clazz);
            this.m_aRefClasses.put(clazz, jReferencedClass);
        }
        return jReferencedClass;
    }

    @Nonnull
    public JDefinedClass ref(@Nonnull TypeElement typeElement, @Nonnull Elements elements) throws ErrorTypeFound, CodeModelBuildingException {
        JCodeModelJavaxLangModelAdapter jCodeModelJavaxLangModelAdapter = new JCodeModelJavaxLangModelAdapter(this, elements);
        return jCodeModelJavaxLangModelAdapter.getClass(typeElement);
    }

    @Nonnull
    public JDefinedClass refWithErrorTypes(@Nonnull TypeElement typeElement, @Nonnull Elements elements) throws CodeModelBuildingException {
        JCodeModelJavaxLangModelAdapter jCodeModelJavaxLangModelAdapter = new JCodeModelJavaxLangModelAdapter(this, elements);
        return jCodeModelJavaxLangModelAdapter.getClassWithErrorTypes(typeElement);
    }

    @Nonnull
    public AbstractJType _ref(@Nonnull Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return AbstractJType.parse(this, clazz.getName());
        }
        return this.ref(clazz);
    }

    @Nonnull
    public AbstractJClass ref(@Nonnull String string) {
        try {
            return this.ref(JCSecureLoader.getContextClassLoader().loadClass(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return this.ref(Class.forName(string));
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return new JDirectClass(this, null, EClassType.CLASS, string);
            }
        }
    }

    @Nonnull
    public AbstractJClass wildcard() {
        if (this.m_aWildcard == null) {
            this.m_aWildcard = this.ref(Object.class).wildcardExtends();
        }
        return this.m_aWildcard;
    }

    @Nonnull
    public AbstractJType parseType(@Nonnull String string) {
        if (string.endsWith("[]")) {
            return this.parseType(string.substring(0, string.length() - 2)).array();
        }
        try {
            return AbstractJType.parse(this, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new TypeNameParser(string).parseTypeName();
        }
    }

    public boolean addDontImportClass(@Nonnull Class<?> clazz) {
        return this.addDontImportClass(this.ref(clazz));
    }

    public boolean addDontImportClass(@Nonnull AbstractJClass abstractJClass) {
        JCValueEnforcer.notNull(abstractJClass, "Class");
        return this.m_aDontImportClasses.add(abstractJClass);
    }

    @Nonnull
    public Set<AbstractJClass> getAllDontImportClasses() {
        return new HashSet<AbstractJClass>(this.m_aDontImportClasses);
    }

    static {
        HashMap<Class<Void>, Class<Object>> hashMap = new HashMap<Class<Void>, Class<Object>>();
        HashMap hashMap2 = new HashMap();
        hashMap.put(Boolean.class, Boolean.TYPE);
        hashMap.put(Byte.class, Byte.TYPE);
        hashMap.put(Character.class, Character.TYPE);
        hashMap.put(Double.class, Double.TYPE);
        hashMap.put(Float.class, Float.TYPE);
        hashMap.put(Integer.class, Integer.TYPE);
        hashMap.put(Long.class, Long.TYPE);
        hashMap.put(Short.class, Short.TYPE);
        hashMap.put(Void.class, Void.TYPE);
        for (Map.Entry entry : hashMap.entrySet()) {
            hashMap2.put(entry.getValue(), entry.getKey());
        }
        s_aBoxToPrimitive = Collections.unmodifiableMap(hashMap);
        s_aPrimitiveToBox = Collections.unmodifiableMap(hashMap2);
    }

    @NotThreadSafe
    private final class TypeNameParser {
        private final String m_sTypeName;
        private int m_nIdx;

        public TypeNameParser(String string) {
            this.m_sTypeName = string;
        }

        @Nonnull
        AbstractJClass parseTypeName() {
            char c;
            int n = this.m_nIdx;
            if (this.m_sTypeName.charAt(this.m_nIdx) == '?') {
                ++this.m_nIdx;
                this._skipWs();
                String string = this.m_sTypeName.substring(this.m_nIdx);
                if (string.startsWith("extends")) {
                    this.m_nIdx += 7;
                    this._skipWs();
                    return this.parseTypeName().wildcardExtends();
                }
                if (string.startsWith("super")) {
                    this.m_nIdx += 5;
                    this._skipWs();
                    return this.parseTypeName().wildcardSuper();
                }
                throw new IllegalArgumentException("only extends/super can follow ?, but found " + this.m_sTypeName.substring(this.m_nIdx));
            }
            while (this.m_nIdx < this.m_sTypeName.length() && (Character.isJavaIdentifierStart(c = this.m_sTypeName.charAt(this.m_nIdx)) || Character.isJavaIdentifierPart(c) || c == '.')) {
                ++this.m_nIdx;
            }
            AbstractJClass abstractJClass = JCodeModel.this.ref(this.m_sTypeName.substring(n, this.m_nIdx));
            return this._parseSuffix(abstractJClass);
        }

        @Nonnull
        private AbstractJClass _parseSuffix(@Nonnull AbstractJClass abstractJClass) {
            if (this.m_nIdx == this.m_sTypeName.length()) {
                return abstractJClass;
            }
            char c = this.m_sTypeName.charAt(this.m_nIdx);
            if (c == '<') {
                return this._parseSuffix(this._parseArguments(abstractJClass));
            }
            if (c == '[') {
                if (this.m_sTypeName.charAt(this.m_nIdx + 1) == ']') {
                    this.m_nIdx += 2;
                    return this._parseSuffix(abstractJClass.array());
                }
                throw new IllegalArgumentException("Expected ']' but found " + this.m_sTypeName.substring(this.m_nIdx + 1));
            }
            return abstractJClass;
        }

        private void _skipWs() {
            while (Character.isWhitespace(this.m_sTypeName.charAt(this.m_nIdx)) && this.m_nIdx < this.m_sTypeName.length()) {
                ++this.m_nIdx;
            }
        }

        @Nonnull
        private AbstractJClass _parseArguments(@Nonnull AbstractJClass abstractJClass) {
            JCValueEnforcer.isTrue(this.m_sTypeName.charAt(this.m_nIdx) == '<', "Expected '<' at current index");
            ++this.m_nIdx;
            ArrayList<AbstractJClass> arrayList = new ArrayList<AbstractJClass>();
            while (true) {
                arrayList.add(this.parseTypeName());
                if (this.m_nIdx == this.m_sTypeName.length()) {
                    throw new IllegalArgumentException("Missing '>' in " + this.m_sTypeName);
                }
                char c = this.m_sTypeName.charAt(this.m_nIdx);
                if (c == '>') {
                    return abstractJClass.narrow(arrayList);
                }
                if (c != ',') {
                    throw new IllegalArgumentException(this.m_sTypeName);
                }
                ++this.m_nIdx;
            }
        }
    }
}

