/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.ChangeInV4;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JOpBinary;
import com.helger.jcodemodel.JOpTernary;
import com.helger.jcodemodel.JOpUnary;
import com.helger.jcodemodel.JOpUnaryTight;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JOp {
    private JOp() {
    }

    public static boolean hasTopOp(@Nullable IJExpression iJExpression) {
        return iJExpression instanceof JOpUnary || iJExpression instanceof JOpBinary;
    }

    @Nonnull
    public static JOpUnary minus(@Nonnull IJExpression iJExpression) {
        return new JOpUnary("-", iJExpression);
    }

    @Nonnull
    public static IJExpression not(@Nonnull IJExpression iJExpression) {
        if (iJExpression == JExpr.TRUE) {
            return JExpr.FALSE;
        }
        if (iJExpression == JExpr.FALSE) {
            return JExpr.TRUE;
        }
        return new JOpUnary("!", iJExpression);
    }

    @Nonnull
    public static JOpUnary complement(@Nonnull IJExpression iJExpression) {
        return new JOpUnary("~", iJExpression);
    }

    @Deprecated
    @Nonnull
    @ChangeInV4
    public static JOpUnaryTight incr(@Nonnull IJExpression iJExpression) {
        return JOp.postincr(iJExpression);
    }

    @Nonnull
    public static JOpUnaryTight postincr(@Nonnull IJExpression iJExpression) {
        return new JOpUnaryTight(iJExpression, "++");
    }

    @Nonnull
    public static JOpUnaryTight preincr(@Nonnull IJExpression iJExpression) {
        return new JOpUnaryTight("++", iJExpression);
    }

    @Deprecated
    @Nonnull
    @ChangeInV4
    public static JOpUnaryTight decr(@Nonnull IJExpression iJExpression) {
        return JOp.postdecr(iJExpression);
    }

    @Nonnull
    public static JOpUnaryTight postdecr(@Nonnull IJExpression iJExpression) {
        return new JOpUnaryTight(iJExpression, "--");
    }

    @Nonnull
    public static JOpUnaryTight predecr(@Nonnull IJExpression iJExpression) {
        return new JOpUnaryTight("--", iJExpression);
    }

    @Nonnull
    public static JOpBinary plus(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JOpBinary(iJExpression, "+", iJExpression2);
    }

    @Nonnull
    public static JOpBinary minus(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JOpBinary(iJExpression, "-", iJExpression2);
    }

    @Nonnull
    public static JOpBinary mul(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JOpBinary(iJExpression, "*", iJExpression2);
    }

    @Nonnull
    public static JOpBinary div(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JOpBinary(iJExpression, "/", iJExpression2);
    }

    @Nonnull
    public static JOpBinary mod(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JOpBinary(iJExpression, "%", iJExpression2);
    }

    @Nonnull
    public static JOpBinary shl(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JOpBinary(iJExpression, "<<", iJExpression2);
    }

    @Nonnull
    public static JOpBinary shr(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JOpBinary(iJExpression, ">>", iJExpression2);
    }

    @Nonnull
    public static JOpBinary shrz(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JOpBinary(iJExpression, ">>>", iJExpression2);
    }

    @Nonnull
    public static JOpBinary band(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JOpBinary(iJExpression, "&", iJExpression2);
    }

    @Nonnull
    public static JOpBinary bor(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JOpBinary(iJExpression, "|", iJExpression2);
    }

    @Nonnull
    public static IJExpression cand(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        if (iJExpression == JExpr.TRUE) {
            return iJExpression2;
        }
        if (iJExpression2 == JExpr.TRUE) {
            return iJExpression;
        }
        if (iJExpression == JExpr.FALSE) {
            return iJExpression;
        }
        if (iJExpression2 == JExpr.FALSE) {
            return iJExpression2;
        }
        return new JOpBinary(iJExpression, "&&", iJExpression2);
    }

    @Nonnull
    public static IJExpression cor(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        if (iJExpression == JExpr.TRUE) {
            return iJExpression;
        }
        if (iJExpression2 == JExpr.TRUE) {
            return iJExpression2;
        }
        if (iJExpression == JExpr.FALSE) {
            return iJExpression2;
        }
        if (iJExpression2 == JExpr.FALSE) {
            return iJExpression;
        }
        return new JOpBinary(iJExpression, "||", iJExpression2);
    }

    @Nonnull
    public static JOpBinary xor(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JOpBinary(iJExpression, "^", iJExpression2);
    }

    @Nonnull
    public static JOpBinary lt(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JOpBinary(iJExpression, "<", iJExpression2);
    }

    @Nonnull
    public static JOpBinary lte(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JOpBinary(iJExpression, "<=", iJExpression2);
    }

    @Nonnull
    public static JOpBinary gt(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JOpBinary(iJExpression, ">", iJExpression2);
    }

    @Nonnull
    public static JOpBinary gte(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JOpBinary(iJExpression, ">=", iJExpression2);
    }

    @Nonnull
    public static JOpBinary eq(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JOpBinary(iJExpression, "==", iJExpression2);
    }

    @Nonnull
    public static JOpBinary ne(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2) {
        return new JOpBinary(iJExpression, "!=", iJExpression2);
    }

    @Nonnull
    public static JOpBinary _instanceof(@Nonnull IJExpression iJExpression, @Nonnull AbstractJType abstractJType) {
        return new JOpBinary(iJExpression, "instanceof", abstractJType);
    }

    @Nonnull
    public static JOpTernary cond(@Nonnull IJExpression iJExpression, @Nonnull IJExpression iJExpression2, @Nonnull IJExpression iJExpression3) {
        return new JOpTernary(iJExpression, "?", iJExpression2, ":", iJExpression3);
    }
}

