/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.ChangeInV4;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;

@ChangeInV4(value="Moved to writer package")
public final class SourcePrintWriter
extends FilterWriter {
    private final String m_sNewLine;

    public SourcePrintWriter(@Nonnull Writer writer, @Nonnull String string) {
        super(writer);
        this.m_sNewLine = string;
    }

    private void _handleException(@Nonnull IOException iOException, @Nonnull String string) {
        System.err.println("Error on Writer: " + string);
        iOException.printStackTrace();
    }

    private void _write(char c) {
        try {
            super.write(c);
        }
        catch (IOException iOException) {
            this._handleException(iOException, "write char");
        }
    }

    private void _write(@Nonnull String string) {
        try {
            super.write(string, 0, string.length());
        }
        catch (IOException iOException) {
            this._handleException(iOException, "write String");
        }
    }

    public void print(char c) {
        this._write(c);
    }

    public void print(@Nonnull String string) {
        this._write(string);
    }

    public void println() {
        this._write(this.m_sNewLine);
    }

    public void println(String string) {
        this._write(string);
        this._write(this.m_sNewLine);
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException iOException) {
            this._handleException(iOException, "close");
        }
    }
}

