/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.fmt;

import com.helger.jcodemodel.fmt.AbstractJResourceFile;
import com.helger.jcodemodel.util.JCSecureLoader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;

public class JStaticFile
extends AbstractJResourceFile {
    private final ClassLoader m_aClassLoader;
    private final String m_sResourceName;
    private final boolean m_bIsResource;

    public JStaticFile(@Nonnull String string) {
        this(string, !string.endsWith(".java"));
    }

    public JStaticFile(@Nonnull String string, boolean bl) {
        this(JCSecureLoader.getClassClassLoader(JStaticFile.class), string, bl);
    }

    public JStaticFile(@Nonnull ClassLoader classLoader, @Nonnull String string, boolean bl) {
        super(string.substring(string.lastIndexOf(47) + 1));
        this.m_aClassLoader = classLoader;
        this.m_sResourceName = string;
        this.m_bIsResource = bl;
    }

    @Override
    public final boolean isResource() {
        return this.m_bIsResource;
    }

    @Override
    public void build(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        try (DataInputStream dataInputStream = new DataInputStream(this.m_aClassLoader.getResourceAsStream(this.m_sResourceName));){
            int n;
            byte[] byArray = new byte[256];
            while ((n = dataInputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
    }
}

