/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.util;

import com.helger.jcodemodel.util.JCArrayHelper;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.util.Locale;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JCStringHelper {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final int STRING_NOT_FOUND = -1;
    public static final char ILLEGAL_CHAR = '\u0000';

    private JCStringHelper() {
    }

    @Nonnegative
    public static int getLength(@Nullable CharSequence charSequence) {
        return charSequence == null ? 0 : charSequence.length();
    }

    public static boolean hasText(@Nullable CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0;
    }

    public static boolean hasNoText(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    @Nonnegative
    public static int getCharCount(@Nullable String string, char c) {
        return string == null ? 0 : JCStringHelper.getCharCount(string.toCharArray(), c);
    }

    @Nonnegative
    public static int getCharCount(@Nullable char[] cArray, char c) {
        int n = 0;
        if (cArray != null) {
            for (char c2 : cArray) {
                if (c2 != c) continue;
                ++n;
            }
        }
        return n;
    }

    @Nonnull
    public static String[] getExplodedArray(char c, @Nullable String string) {
        return JCStringHelper.getExplodedArray(c, string, -1);
    }

    @Nonnull
    public static String[] getExplodedArray(char c, @Nullable String string, @CheckForSigned int n) {
        int n2;
        if (n == 1) {
            return new String[]{string};
        }
        if (JCStringHelper.hasNoText(string)) {
            return EMPTY_STRING_ARRAY;
        }
        int n3 = 1 + JCStringHelper.getCharCount(string, c);
        if (n3 == 1) {
            return new String[]{string};
        }
        String[] stringArray = new String[n < 1 ? n3 : Math.min(n3, n)];
        int n4 = 0;
        int n5 = 0;
        while ((n2 = string.indexOf(c, n4)) >= 0) {
            stringArray[n5++] = string.substring(n4, n2);
            n4 = n2 + 1;
            if (n <= 0 || n5 != n - 1) continue;
            break;
        }
        stringArray[n5++] = string.substring(n4);
        if (n5 != stringArray.length) {
            throw new IllegalStateException("Added " + n5 + " but expected " + stringArray.length);
        }
        return stringArray;
    }

    @Nullable
    public static String replaceAll(@Nullable String string, char c, char c2) {
        if (JCStringHelper.hasNoText(string)) {
            return string;
        }
        if (c == c2) {
            return string;
        }
        int n = string.indexOf(c, 0);
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = 0;
        do {
            stringBuilder.append(string, n2, n).append(c2);
            n2 = ++n;
        } while ((n = string.indexOf(c, n)) != -1);
        stringBuilder.append(string, n2, string.length());
        return stringBuilder.toString();
    }

    @Nullable
    public static String replaceAllRepeatedly(@Nullable String string, @Nonnull String string2, @Nonnull String string3) {
        String string4;
        JCValueEnforcer.notEmpty(string2, "SearchText");
        JCValueEnforcer.notNull(string3, "ReplacementText");
        JCValueEnforcer.isFalse(string3.contains(string2), "Loop detection: replacementText must not contain searchText");
        if (JCStringHelper.hasNoText(string)) {
            return string;
        }
        String string5 = string;
        while (!(string4 = string5).equals(string5 = string5.replace(string2, string3))) {
        }
        return string5;
    }

    public static char getFirstChar(@Nullable CharSequence charSequence) {
        return JCStringHelper.hasText(charSequence) ? charSequence.charAt(0) : (char)'\u0000';
    }

    public static char getLastChar(@Nullable CharSequence charSequence) {
        int n = JCStringHelper.getLength(charSequence);
        return n > 0 ? charSequence.charAt(n - 1) : (char)'\u0000';
    }

    public static boolean endsWithAny(@Nullable CharSequence charSequence, @Nullable char[] cArray) {
        return JCStringHelper.hasText(charSequence) && cArray != null && JCArrayHelper.contains(cArray, JCStringHelper.getLastChar(charSequence));
    }

    public static boolean endsWithCaseInsensitive(@Nullable String string, @Nullable String string2) {
        return JCStringHelper.hasText(string) && JCStringHelper.hasText(string2) && string.toUpperCase(Locale.ROOT).endsWith(string2.toUpperCase(Locale.ROOT));
    }
}

