/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.writer;

import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.SourcePrintWriter;
import com.helger.jcodemodel.util.JCStringHelper;
import com.helger.jcodemodel.util.JCValueEnforcer;
import com.helger.jcodemodel.writer.AbstractCodeWriter;
import com.helger.jcodemodel.writer.FilterCodeWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class ProgressCodeWriter
extends FilterCodeWriter {
    private final IProgressTracker m_aPT;

    public ProgressCodeWriter(@Nonnull AbstractCodeWriter abstractCodeWriter, @Nonnull IProgressTracker iProgressTracker) {
        super(abstractCodeWriter);
        JCValueEnforcer.notNull(iProgressTracker, "Progress");
        this.m_aPT = iProgressTracker;
    }

    protected void report(@Nonnull String string, @Nonnull String string2) {
        if (JCStringHelper.hasNoText(string)) {
            this.m_aPT.println(string2);
        } else {
            this.m_aPT.println(string + '/' + string2);
        }
    }

    @Override
    public OutputStream openBinary(@Nonnull String string, @Nonnull String string2) throws IOException {
        this.report(string, string2);
        return super.openBinary(string, string2);
    }

    @Override
    public SourcePrintWriter openSource(@Nonnull JPackage jPackage, @Nonnull String string) throws IOException {
        this.report(ProgressCodeWriter.toDirName(jPackage), string);
        return super.openSource(jPackage, string);
    }

    @FunctionalInterface
    public static interface IProgressTracker
    extends Serializable {
        public void println(@Nonnull String var1);
    }
}

