/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.writer;

import com.helger.jcodemodel.util.JCStringHelper;
import com.helger.jcodemodel.writer.AbstractCodeWriter;
import com.helger.jcodemodel.writer.JCMWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;

public class ZipCodeWriter
extends AbstractCodeWriter {
    private final ZipOutputStream m_aZOS;
    private final OutputStream m_aFOS;

    public ZipCodeWriter(@Nonnull OutputStream outputStream) {
        this(outputStream, JCMWriter.getDefaultNewLine());
    }

    public ZipCodeWriter(@Nonnull OutputStream outputStream, @Nonnull String string) {
        super(null, string);
        this.m_aZOS = new ZipOutputStream(outputStream);
        this.m_aFOS = new FilterOutputStream(this.m_aZOS){

            @Override
            public void close() {
            }
        };
    }

    @Override
    public OutputStream openBinary(@Nonnull String string, @Nonnull String string2) throws IOException {
        String string3 = JCStringHelper.hasText(string) ? string + '/' + string2 : string2;
        this.m_aZOS.putNextEntry(new ZipEntry(string3));
        return this.m_aFOS;
    }

    @Override
    public void close() throws IOException {
        this.m_aZOS.close();
    }
}

