/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.company;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ObjectType;
import com.helger.masterdata.company.CompanySite;
import com.helger.masterdata.company.ICompany;
import com.helger.masterdata.company.ICompanySite;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Company
implements ICompany,
Serializable {
    public static final ObjectType OT = new ObjectType("company");
    public static final String FIELD_ID = "id";
    public static final String FIELD_PUBLICNAME = "pubname";
    public static final String FIELD_OFFICIALNAME = "offname";
    public static final String FIELD_STEHQ = "hqsite";
    private final String m_sID;
    private String m_sPublicName;
    private String m_sOfficialName;
    private final ICommonsMap<String, CompanySite> m_aAllSites = new CommonsHashMap();
    private CompanySite m_aHeadQuarterSite;

    public Company(@Nonnull @Nonempty String string) {
        this.m_sID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
    }

    @Nonnull
    public ObjectType getObjectType() {
        return OT;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nullable
    public String getPublicName() {
        return this.m_sPublicName;
    }

    @Nonnull
    public EChange setPublicName(@Nullable String string) {
        if (EqualsHelper.equals((Object)this.m_sPublicName, (Object)string)) {
            return EChange.UNCHANGED;
        }
        this.m_sPublicName = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getOfficialName() {
        return this.m_sOfficialName;
    }

    @Nonnull
    public EChange setOfficialName(@Nullable String string) {
        if (EqualsHelper.equals((Object)this.m_sOfficialName, (Object)string)) {
            return EChange.UNCHANGED;
        }
        this.m_sOfficialName = string;
        return EChange.CHANGED;
    }

    @Override
    @Nonnegative
    public int getSiteCount() {
        return this.m_aAllSites.size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<? extends ICompanySite> getAllSites() {
        return this.m_aAllSites.copyOfValues();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<? extends ICompanySite> getAllPhysicalSites() {
        return this.m_aAllSites.copyOfValues(ICompanySite::isPhysicalSite);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<? extends ICompanySite> getAllVirtualSites() {
        return this.m_aAllSites.copyOfValues(ICompanySite::isVirtualSite);
    }

    @Nonnull
    public EChange addSite(@Nonnull CompanySite companySite) {
        ValueEnforcer.notNull((Object)companySite, (String)"Site");
        String string = companySite.getID();
        if (this.m_aAllSites.containsKey((Object)string)) {
            return EChange.UNCHANGED;
        }
        this.m_aAllSites.put((Object)string, (Object)companySite);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeSite(@Nonnull ICompanySite iCompanySite) {
        ValueEnforcer.notNull((Object)iCompanySite, (String)"Site");
        if (this.m_aHeadQuarterSite != null && iCompanySite.equals(this.m_aHeadQuarterSite)) {
            this.m_aHeadQuarterSite = null;
        }
        return this.m_aAllSites.removeObject(iCompanySite.getID());
    }

    @Override
    @Nullable
    public ICompanySite getSiteOfID(@Nullable String string) {
        return (ICompanySite)this.m_aAllSites.get((Object)string);
    }

    @Override
    @Nullable
    public ICompanySite getHeadQuarterSite() {
        if (this.m_aHeadQuarterSite != null) {
            return this.m_aHeadQuarterSite;
        }
        return (ICompanySite)this.m_aAllSites.getFirstValue();
    }

    @Nonnull
    public EChange setHeadQuarterSite(@Nonnull CompanySite companySite) {
        ValueEnforcer.notNull((Object)companySite, (String)"HeadQuarterSite");
        if (!this.m_aAllSites.containsKey((Object)companySite.getID())) {
            throw new IllegalArgumentException("Passed headquarter site does not yet belong to this company: " + companySite);
        }
        if (companySite.equals(this.m_aHeadQuarterSite)) {
            return EChange.UNCHANGED;
        }
        this.m_aHeadQuarterSite = companySite;
        return EChange.CHANGED;
    }

    @Override
    public boolean containsAtLeastOneNotDeletableSite() {
        return CollectionHelper.containsAny((Iterable)this.m_aAllSites.values(), companySite -> !companySite.isDeletable());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Company company = (Company)object;
        return this.m_sID.equals(company.m_sID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("ID", (Object)this.m_sID).appendIfNotNull("publicName", (Object)this.m_sPublicName).appendIfNotNull("officialName", (Object)this.m_sOfficialName).append("allSites", this.m_aAllSites).appendIfNotNull("headquarter", (Object)this.m_aHeadQuarterSite).getToString();
    }
}

