/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.din;

import com.helger.commons.id.IHasID;
import javax.annotation.Nonnegative;

public interface IDINSize
extends IHasID<String> {
    @Nonnegative
    public int getWidthMM();

    @Nonnegative
    default public double getWidthCM() {
        return (double)this.getWidthMM() / 10.0;
    }

    @Nonnegative
    default public double getWidthPixel(@Nonnegative int n) {
        return (double)(n * this.getWidthMM()) / (double)25.4f;
    }

    @Nonnegative
    default public long getWidthPixelLong(@Nonnegative int n) {
        return Math.round(this.getWidthPixel(n));
    }

    @Nonnegative
    default public double getWidthDPI(@Nonnegative int n) {
        return (double)n * (double)25.4f / (double)this.getWidthMM();
    }

    @Nonnegative
    default public long getWidthDPILong(@Nonnegative int n) {
        return Math.round(this.getWidthDPI(n));
    }

    @Nonnegative
    public int getHeightMM();

    @Nonnegative
    default public double getHeightCM() {
        return (double)this.getHeightMM() / 10.0;
    }

    @Nonnegative
    default public double getHeightPixel(@Nonnegative int n) {
        return (double)(n * this.getHeightMM()) / (double)25.4f;
    }

    @Nonnegative
    default public long getHeightPixelLong(@Nonnegative int n) {
        return Math.round(this.getHeightPixel(n));
    }

    @Nonnegative
    default public double getHeightDPI(@Nonnegative int n) {
        return (double)n * (double)25.4f / (double)this.getHeightMM();
    }

    @Nonnegative
    default public long getHeightDPILong(@Nonnegative int n) {
        return Math.round(this.getHeightDPI(n));
    }
}

