/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.ean;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.state.EValidity;
import com.helger.commons.string.StringHelper;
import com.helger.masterdata.ean.AbstractUPCEAN;
import com.helger.masterdata.ean.EEANChecksumMode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class EAN13
extends AbstractUPCEAN {
    public EAN13(@Nonnull String string) {
        this(string, DEFAULT_CHECKSUM_MODE);
    }

    public EAN13(@Nonnull String string, @Nonnull EEANChecksumMode eEANChecksumMode) {
        super(string, eEANChecksumMode);
    }

    @Override
    @Nonnull
    public EValidity validate() {
        return EAN13.validateMessage(this.getMessage());
    }

    @Nonnull
    public static EValidity validateMessage(@Nullable String string) {
        int n = StringHelper.getLength((CharSequence)string);
        if (n >= 12 && n <= 13 && AbstractUPCEAN.validateMessage(string).isValid()) {
            return EValidity.VALID;
        }
        return EValidity.INVALID;
    }

    @Nonnull
    public String getWithCorrectChecksum() {
        return EAN13.getWithCorrectChecksum(this.getMessage(), this.getChecksumMode());
    }

    @Nonnull
    public static String getWithCorrectChecksum(@Nonnull String string, @Nonnull EEANChecksumMode eEANChecksumMode) {
        ValueEnforcer.notNull((Object)string, (String)"Msg");
        ValueEnforcer.notNull((Object)((Object)eEANChecksumMode), (String)"ChecksumMode");
        EEANChecksumMode eEANChecksumMode2 = eEANChecksumMode;
        if (eEANChecksumMode2 == EEANChecksumMode.AUTO) {
            if (string.length() == 12) {
                eEANChecksumMode2 = EEANChecksumMode.ADD;
            } else if (string.length() == 13) {
                eEANChecksumMode2 = EEANChecksumMode.CHECK;
            } else {
                throw new IllegalArgumentException("Failed to automatically detect the checksum mode");
            }
        }
        switch (eEANChecksumMode2) {
            case ADD: {
                if (string.length() != 12) {
                    throw new IllegalArgumentException("Message must be 12 characters long");
                }
                return string + EAN13.calcChecksumChar(string, 12);
            }
            case CHECK: {
                char c;
                if (string.length() != 13) {
                    throw new IllegalArgumentException("Message must be 13 characters long");
                }
                char c2 = string.charAt(12);
                if (c2 != (c = EAN13.calcChecksumChar(string, 12))) {
                    throw new IllegalArgumentException("Checksum is bad (" + c2 + "). Expected: " + c);
                }
                return string;
            }
            case IGNORE: {
                return string;
            }
        }
        throw new IllegalArgumentException("Unknown checksum mode: " + (Object)((Object)eEANChecksumMode2));
    }
}

