/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.ean;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.state.EValidity;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.masterdata.ean.AbstractUPCEAN;
import com.helger.masterdata.ean.EEANChecksumMode;
import com.helger.masterdata.ean.UPCA;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class UPCE
extends AbstractUPCEAN {
    public UPCE(@Nonnull String string) {
        this(string, DEFAULT_CHECKSUM_MODE);
    }

    public UPCE(@Nonnull String string, @Nonnull EEANChecksumMode eEANChecksumMode) {
        super(string, eEANChecksumMode);
    }

    @Override
    @Nonnull
    public EValidity validate() {
        return UPCE.validateMessage(this.getMessage());
    }

    @Nullable
    public static String getCompactMessage(String string) {
        UPCA.validateMessage(string);
        String string2 = UPCA.handleChecksum(string, EEANChecksumMode.AUTO);
        byte by = UPCE._extractNumberSystem(string2);
        if (by != 0 && by != 1) {
            return null;
        }
        byte by2 = StringParser.parseByte((String)string2.substring(11, 12), (byte)-1);
        if (by2 == -1) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Byte.toString(by));
        String string3 = string2.substring(1, 6);
        String string4 = string2.substring(6, 11);
        String string5 = string3.substring(2, 5);
        String string6 = string4.substring(0, 2);
        if ("000|100|200".indexOf(string5) >= 0 && "00".equals(string6)) {
            stringBuilder.append(string3.substring(0, 2));
            stringBuilder.append(string4.substring(2, 5));
            stringBuilder.append(string5.charAt(0));
        } else {
            string6 = string4.substring(0, 3);
            if ("300|400|500|600|700|800|900".indexOf(string5) >= 0 && "000".equals(string6)) {
                stringBuilder.append(string3.substring(0, 3));
                stringBuilder.append(string4.substring(3, 5));
                stringBuilder.append('3');
            } else {
                string5 = string3.substring(3, 5);
                string6 = string4.substring(0, 4);
                if ("10|20|30|40|50|60|70|80|90".indexOf(string5) >= 0 && "0000".equals(string6)) {
                    stringBuilder.append(string3.substring(0, 4));
                    stringBuilder.append(string4.substring(4, 5));
                    stringBuilder.append('4');
                } else {
                    string5 = string3.substring(4, 5);
                    string6 = string4.substring(4, 5);
                    if (!"0".equals(string5) && "5|6|7|8|9".indexOf(string6) >= 0) {
                        stringBuilder.append(string3);
                        stringBuilder.append(string6);
                    } else {
                        return null;
                    }
                }
            }
        }
        stringBuilder.append(Byte.toString(by2));
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getExpandedMessage(@Nonnull String string) {
        char c = string.length() == 8 ? string.charAt(7) : (char)'\u0000';
        String string2 = string.substring(0, 7);
        byte by = UPCE._extractNumberSystem(string2);
        if (by != 0 && by != 1) {
            throw new IllegalArgumentException("Invalid UPC-E message: " + string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Byte.toString(by));
        byte by2 = StringParser.parseByte((String)string2.substring(6, 7), (byte)-1);
        if (by2 >= 0 && by2 <= 2) {
            stringBuilder.append(string2.substring(1, 3));
            stringBuilder.append(Byte.toString(by2));
            stringBuilder.append("0000");
            stringBuilder.append(string2.substring(3, 6));
        } else if (by2 == 3) {
            stringBuilder.append(string2.substring(1, 4));
            stringBuilder.append("00000");
            stringBuilder.append(string2.substring(4, 6));
        } else if (by2 == 4) {
            stringBuilder.append(string2.substring(1, 5));
            stringBuilder.append("00000");
            stringBuilder.append(string2.substring(5, 6));
        } else if (by2 >= 5 && by2 <= 9) {
            stringBuilder.append(string2.substring(1, 6));
            stringBuilder.append("0000");
            stringBuilder.append(Byte.toString(by2));
        } else {
            throw new IllegalArgumentException("Internal error");
        }
        String string3 = stringBuilder.toString();
        char c2 = UPCE.calcChecksumChar(string3, string3.length());
        if (c != '\u0000' && c != c2) {
            throw new IllegalArgumentException("Invalid checksum. Expected " + c2 + " but was " + c);
        }
        return string3 + c2;
    }

    private static byte _extractNumberSystem(@Nonnull String string) {
        return StringParser.parseByte((String)string.substring(0, 1), (byte)-1);
    }

    @Nonnull
    public static EValidity validateMessage(@Nullable String string) {
        byte by;
        int n = StringHelper.getLength((CharSequence)string);
        if (n >= 7 && n <= 8 && (by = UPCE._extractNumberSystem(string)) >= 0 && by <= 1) {
            return EValidity.VALID;
        }
        return EValidity.INVALID;
    }

    public static String handleChecksum(@Nonnull String string, @Nonnull EEANChecksumMode eEANChecksumMode) {
        ValueEnforcer.notNull((Object)string, (String)"Msg");
        ValueEnforcer.notNull((Object)((Object)eEANChecksumMode), (String)"ChecksumMode");
        EEANChecksumMode eEANChecksumMode2 = eEANChecksumMode;
        if (eEANChecksumMode2 == EEANChecksumMode.AUTO) {
            if (string.length() == 7) {
                eEANChecksumMode2 = EEANChecksumMode.ADD;
            } else if (string.length() == 8) {
                eEANChecksumMode2 = EEANChecksumMode.CHECK;
            } else {
                throw new IllegalArgumentException("Failed to automatically detect the checksum mode");
            }
        }
        switch (eEANChecksumMode2) {
            case ADD: {
                if (string.length() != 7) {
                    throw new IllegalArgumentException("Message must be 7 characters long");
                }
                return string + UPCE.getExpandedMessage(string).charAt(11);
            }
            case CHECK: {
                char c;
                if (string.length() != 8) {
                    throw new IllegalArgumentException("Message must be 8 characters long");
                }
                char c2 = string.charAt(7);
                if (c2 != (c = UPCE.getExpandedMessage(string).charAt(11))) {
                    throw new IllegalArgumentException("Checksum is bad (" + c2 + "). Expected: " + c);
                }
                return string;
            }
            case IGNORE: {
                return string;
            }
        }
        throw new IllegalArgumentException("Unknown checksum mode: " + (Object)((Object)eEANChecksumMode2));
    }
}

