/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.exchangeratio;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public class ExchangeRatio
implements Serializable {
    private final LocalDate m_aDate;
    private final BigDecimal m_aRatio;

    public ExchangeRatio(@Nonnull LocalDate localDate, @Nonnull @Nonnegative BigDecimal bigDecimal) {
        this.m_aDate = (LocalDate)ValueEnforcer.notNull((Object)localDate, (String)"Date");
        this.m_aRatio = ValueEnforcer.isGT0((BigDecimal)bigDecimal, (String)"Ratio");
    }

    @Nonnull
    public LocalDate getDate() {
        return this.m_aDate;
    }

    @Nonnegative
    @Nonnull
    public BigDecimal getRatio() {
        return this.m_aRatio;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ExchangeRatio exchangeRatio = (ExchangeRatio)object;
        return this.m_aDate.equals(exchangeRatio.m_aDate) && EqualsHelper.equals((Object)this.m_aRatio, (Object)exchangeRatio.m_aRatio);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aDate).append((Object)this.m_aRatio).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("date", (Object)this.m_aDate).append("ratio", (Object)this.m_aRatio).getToString();
    }
}

