/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.nuts;

import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ENutsLevel implements IHasID<String>
{
    COUNTRY("c", 2),
    NUTS1("nuts1", 3),
    NUTS2("nuts2", 4),
    NUTS3("nuts3", 5);

    private final String m_sID;
    private final int m_nCharCount;

    private ENutsLevel(String string2, int n2) {
        this.m_sID = string2;
        this.m_nCharCount = n2;
    }

    @Nonnull
    public String getID() {
        return this.m_sID;
    }

    @Nonnegative
    public int getCharCount() {
        return this.m_nCharCount;
    }

    @Nullable
    public static ENutsLevel getFromIDOrNull(@Nullable String string) {
        return (ENutsLevel)EnumHelper.getFromIDOrNull(ENutsLevel.class, (Object)string);
    }

    @Nullable
    public static ENutsLevel getFromLengthOrNull(int n) {
        for (ENutsLevel eNutsLevel : ENutsLevel.values()) {
            if (n != eNutsLevel.m_nCharCount) continue;
            return eNutsLevel;
        }
        return null;
    }

    @Nonnull
    public static ENutsLevel getFromLengthOrThrow(int n) {
        ENutsLevel eNutsLevel = ENutsLevel.getFromLengthOrNull(n);
        if (eNutsLevel == null) {
            throw new IllegalArgumentException("Invalid length " + n + " for a NUTS entry");
        }
        return eNutsLevel;
    }
}

